/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.cartography.color;

import java.awt.image.BufferedImage;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import journeymap.client.render.texture.TextureCache;
import journeymap.common.Journeymap;
import journeymap.common.log.LogFormatter;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import org.apache.logging.log4j.Logger;

@ParametersAreNonnullByDefault
public class ColoredSprite {
    private static Logger logger = Journeymap.getLogger();
    private final Integer color;
    private final TextureAtlasSprite sprite;

    public ColoredSprite(TextureAtlasSprite sprite, @Nullable Integer color) {
        this.sprite = sprite;
        this.color = null;
    }

    public ColoredSprite(BakedQuad quad) {
        this.sprite = quad.m_173410_();
        this.color = null;
    }

    public String getIconName() {
        return this.sprite.m_118413_().m_135815_();
    }

    @Nullable
    public Integer getColor() {
        return this.color;
    }

    public boolean hasColor() {
        return this.color != null;
    }

    @Nullable
    public BufferedImage getColoredImage() {
        try {
            ResourceLocation resourceLocation = new ResourceLocation(this.getIconName());
            if (resourceLocation.equals((Object)new ResourceLocation("missingno"))) {
                return null;
            }
            BufferedImage image = this.getFrameTextureData(this.sprite);
            if (image == null || image.getWidth() == 0) {
                image = this.getImageResource(this.sprite);
            }
            if (image == null || image.getWidth() == 0) {
                return null;
            }
            return this.applyColor(image);
        }
        catch (Throwable e1) {
            if (logger.isDebugEnabled()) {
                logger.error("ColoredSprite: Error getting image for " + this.getIconName() + ": " + LogFormatter.toString(e1));
            }
            return null;
        }
    }

    private BufferedImage getFrameTextureData(TextureAtlasSprite tas) {
        try {
            int[] rgb;
            if (tas.m_118415_() > 0 && (rgb = tas.f_118342_[0].m_85118_()).length > 0) {
                int width = tas.m_118405_();
                int height = tas.m_118408_();
                BufferedImage textureImg = new BufferedImage(width, height, 2);
                textureImg.setRGB(0, 0, width, height, rgb, 0, width);
                return textureImg;
            }
        }
        catch (Throwable t) {
            logger.error(String.format("ColoredSprite: Unable to use frame data for %s: %s", tas.m_118413_().m_135815_(), t.getMessage()));
        }
        return null;
    }

    private BufferedImage getImageResource(TextureAtlasSprite tas) {
        try {
            ResourceLocation iconNameLoc = new ResourceLocation(tas.m_118413_().m_135815_());
            ResourceLocation fileLoc = new ResourceLocation(iconNameLoc.m_135827_(), "textures/" + iconNameLoc.m_135815_() + ".png");
            return TextureCache.resolveImage(fileLoc);
        }
        catch (Throwable t) {
            logger.error(String.format("ColoredSprite: Unable to use texture file for %s: %s", tas.m_118413_().m_135815_(), t.getMessage()));
            return null;
        }
    }

    private BufferedImage applyColor(BufferedImage original) {
        return original;
    }
}

