/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.io.nbt;

import journeymap.client.io.nbt.RegionLoader;
import journeymap.client.model.ChunkMD;
import journeymap.common.Journeymap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.server.IntegratedServer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.ChunkSource;
import net.minecraft.world.level.chunk.EmptyLevelChunk;
import net.minecraft.world.level.chunk.ImposterProtoChunk;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.storage.ChunkSerializer;
import net.minecraft.world.level.chunk.storage.ChunkStorage;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureManager;
import org.apache.logging.log4j.Logger;

public class JMChunkLoader {
    private static Logger logger = Journeymap.getLogger();

    public static ChunkMD getChunkMD(ChunkStorage loader, Minecraft mc, ChunkPos coord, boolean forceRetain) {
        if (RegionLoader.getRegionFile(mc, coord.f_45578_, coord.f_45579_).exists()) {
            IntegratedServer integratedServer = mc.m_91092_();
            ServerLevel serverWorld = integratedServer.m_129880_(mc.f_91074_.f_19853_.m_46472_());
            LevelChunk chunk = JMChunkLoader.getChunkFromRegion(serverWorld, coord, loader);
            if (chunk != null) {
                chunk.m_62913_(true);
                return new ChunkMD(chunk, forceRetain);
            }
        } else {
            logger.warn("Region doesn't exist for chunk: " + coord);
        }
        return null;
    }

    private static LevelChunk getChunkFromRegion(ServerLevel world, ChunkPos coord, ChunkStorage loader) {
        try {
            CompoundTag nbt = loader.m_63512_(coord);
            if (nbt != null) {
                ImposterProtoChunk primer = (ImposterProtoChunk)ChunkSerializer.m_63457_((ServerLevel)world, (StructureManager)world.m_8875_(), (PoiManager)world.m_8904_(), (ChunkPos)coord, (CompoundTag)nbt);
                LevelChunk chunk = primer.m_62768_();
                return chunk;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static ChunkMD getChunkMdFromMemory(Level world, int chunkX, int chunkZ) {
        ChunkSource provider;
        if (world != null && (provider = world.m_7726_()) != null) {
            LevelChunk theChunk = world.m_6325_(chunkX, chunkZ);
            theChunk.m_62913_(true);
            if (theChunk != null && theChunk.f_62775_ && !(theChunk instanceof EmptyLevelChunk)) {
                return new ChunkMD(theChunk);
            }
        }
        return null;
    }
}

