/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.io.nbt;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import journeymap.client.io.FileHandler;
import journeymap.client.io.RegionImageHandler;
import journeymap.client.model.MapType;
import journeymap.client.model.RegionCoord;
import journeymap.client.model.RegionImageCache;
import journeymap.common.Journeymap;
import net.minecraft.client.Minecraft;
import net.minecraft.world.level.ChunkPos;
import org.apache.logging.log4j.Logger;

public class RegionLoader {
    private static final Pattern anvilPattern = Pattern.compile("r\\.([^\\.]+)\\.([^\\.]+)\\.mca");
    final Logger logger = Journeymap.getLogger();
    final MapType mapType;
    final Stack<RegionCoord> regions;
    final int regionsFound;

    public RegionLoader(Minecraft minecraft, MapType mapType, boolean all) throws IOException {
        this.mapType = mapType;
        this.regions = this.findRegions(minecraft, mapType, all);
        this.regionsFound = this.regions.size();
    }

    public static File getRegionFile(Minecraft minecraft, int dimension, int chunkX, int chunkZ) {
        File regionDir = new File(FileHandler.getWorldSaveDir(minecraft), "region");
        File regionFile = new File(regionDir, String.format("r.%s.%s.mca", chunkX >> 5, chunkZ >> 5));
        return regionFile;
    }

    public static File getRegionFile(Minecraft minecraft, int chunkX, int chunkZ) {
        File regionDir = new File(FileHandler.getWorldSaveDir(minecraft), "region");
        File regionFile = new File(regionDir, String.format("r.%s.%s.mca", chunkX >> 5, chunkZ >> 5));
        return regionFile;
    }

    public Iterator<RegionCoord> regionIterator() {
        return this.regions.iterator();
    }

    public Stack<RegionCoord> getRegions() {
        return this.regions;
    }

    public int getRegionsFound() {
        return this.regionsFound;
    }

    public boolean isUnderground() {
        return this.mapType.isUnderground();
    }

    public Integer getVSlice() {
        return this.mapType.vSlice;
    }

    Stack<RegionCoord> findRegions(Minecraft mc, MapType mapType, boolean all) {
        RegionCoord playerRc;
        File[] anvilFiles;
        File mcWorldDir = FileHandler.getMCWorldDir(mc, mapType.dimension);
        File regionDir = new File(mcWorldDir, "region");
        if (!regionDir.exists() && !regionDir.mkdirs()) {
            this.logger.warn("MC world region directory isn't usable: " + regionDir);
            return new Stack<RegionCoord>();
        }
        RegionImageCache.INSTANCE.flushToDisk(false);
        RegionImageCache.INSTANCE.clear();
        File jmImageWorldDir = FileHandler.getJMWorldDir(mc);
        Stack<RegionCoord> rcStack = new Stack<RegionCoord>();
        int validFileCount = 0;
        int existingImageCount = 0;
        block0: for (File anvilFile : anvilFiles = regionDir.listFiles()) {
            Matcher matcher = anvilPattern.matcher(anvilFile.getName());
            if (anvilFile.isDirectory() || !matcher.matches()) continue;
            ++validFileCount;
            String x = matcher.group(1);
            String z = matcher.group(2);
            if (x == null || z == null) continue;
            RegionCoord rc = new RegionCoord(jmImageWorldDir, Integer.parseInt(x), Integer.parseInt(z), mapType.dimension);
            if (all) {
                rcStack.add(rc);
                continue;
            }
            if (!RegionImageHandler.getRegionImageFile(rc, mapType, false).exists()) {
                List<ChunkPos> chunkCoords = rc.getChunkCoordsInRegion();
                for (ChunkPos coord : chunkCoords) {
                    if (!mc.f_91073_.m_7232_(coord.f_45578_, coord.f_45579_)) continue;
                    rcStack.add(rc);
                    continue block0;
                }
                continue;
            }
            ++existingImageCount;
        }
        if (rcStack.isEmpty() && validFileCount != existingImageCount) {
            this.logger.warn("Anvil region files in " + regionDir + ": " + validFileCount + ", matching image files: " + existingImageCount + ", but found nothing to do for mapType " + mapType);
        }
        if (rcStack.contains(playerRc = RegionCoord.fromChunkPos(jmImageWorldDir, mapType, mc.f_91074_.m_146902_().f_45578_, mc.f_91074_.m_146902_().f_45579_))) {
            rcStack.remove(playerRc);
        }
        Collections.sort(rcStack, new Comparator<RegionCoord>(){

            @Override
            public int compare(RegionCoord o1, RegionCoord o2) {
                Float d1 = Float.valueOf(this.distanceToPlayer(o1));
                Float d2 = Float.valueOf(this.distanceToPlayer(o2));
                int comp = d2.compareTo(d1);
                if (comp == 0) {
                    return o2.compareTo(o1);
                }
                return comp;
            }

            float distanceToPlayer(RegionCoord rc) {
                float x = rc.regionX - playerRc.regionX;
                float z = rc.regionZ - playerRc.regionZ;
                return x * x + z * z;
            }
        });
        rcStack.add(playerRc);
        return rcStack;
    }

    public MapType getMapType() {
        return this.mapType;
    }
}

