/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.mod.vanilla;

import javax.annotation.Nullable;
import journeymap.client.JourneymapClient;
import journeymap.client.mod.IBlockColorProxy;
import journeymap.client.mod.ModBlockDelegate;
import journeymap.client.model.BlockMD;
import journeymap.client.model.ChunkMD;
import journeymap.common.Journeymap;
import journeymap.common.log.LogFormatter;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.block.BlockColors;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FlowerBlock;
import net.minecraft.world.level.block.FlowerPotBlock;
import net.minecraft.world.level.block.state.BlockState;

public enum FlowerBlockProxy implements IBlockColorProxy
{
    INSTANCE;

    boolean enabled = true;
    private final BlockColors blockColors = Minecraft.m_91087_().m_91298_();

    @Override
    public int deriveBlockColor(BlockMD blockMD, @Nullable ChunkMD chunkMD, @Nullable BlockPos blockPos) {
        Integer color;
        if (blockMD.getBlock() instanceof FlowerBlock && (color = this.getFlowerColor(blockMD.getBlockState())) != null) {
            return color;
        }
        return ModBlockDelegate.INSTANCE.getDefaultBlockColorProxy().deriveBlockColor(blockMD, chunkMD, blockPos);
    }

    @Override
    public int getBlockColor(ChunkMD chunkMD, BlockMD blockMD, BlockPos blockPos) {
        if (blockMD.getBlock() instanceof FlowerBlock) {
            return blockMD.getTextureColor();
        }
        if (blockMD.getBlock() instanceof FlowerPotBlock && JourneymapClient.getInstance().getCoreProperties().mapPlants.get().booleanValue()) {
            try {
                BlockState blockState = blockMD.getBlockState();
                ItemStack iStack = ((FlowerPotBlock)blockState.m_60734_()).m_7397_((BlockGetter)chunkMD.getWorld(), blockPos, blockState);
                if (iStack != null) {
                    BlockState contentBlockState = Block.m_49814_((Item)iStack.m_41720_()).m_49966_();
                    return BlockMD.get(contentBlockState).getTextureColor();
                }
            }
            catch (Exception e) {
                Journeymap.getLogger().error("Error checking FlowerPot: " + e, (Object)LogFormatter.toPartialString(e));
                this.enabled = false;
            }
        }
        return ModBlockDelegate.INSTANCE.getDefaultBlockColorProxy().getBlockColor(chunkMD, blockMD, blockPos);
    }

    private Integer getFlowerColor(BlockState blockState) {
        Block block;
        if (blockState.m_60734_() instanceof FlowerBlock && (block = blockState.m_60734_()) != null) {
            switch (block.getRegistryName().m_135815_()) {
                case "poppy": {
                    return 9962502;
                }
                case "blue_orchid": {
                    return 1998518;
                }
                case "allium": {
                    return 8735158;
                }
                case "azure_bluet": {
                    return 10330535;
                }
                case "red_tulip": {
                    return 9962502;
                }
                case "orange_tulip": {
                    return 10704922;
                }
                case "white_tulip": {
                    return 0xB0B0B0;
                }
                case "pink_tulip": {
                    return 11573936;
                }
                case "oxeye_daisy": {
                    return 0xB3B3B3;
                }
                case "dandelion": {
                    return 11514881;
                }
                case "cornflower": {
                    return 3361970;
                }
                case "lily_of_the_valley": {
                    return 0xFFFFFF;
                }
                case "wither_rose": {
                    return 0x191919;
                }
            }
            return 0;
        }
        return null;
    }
}

