/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.model;

import com.google.common.base.Strings;
import com.google.common.cache.CacheLoader;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.util.UUID;
import journeymap.client.JourneymapClient;
import journeymap.client.model.EntityHelper;
import journeymap.client.properties.CoreProperties;
import journeymap.common.Journeymap;
import journeymap.common.helper.DimensionHelper;
import journeymap.common.log.LogFormatter;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.client.multiplayer.PlayerInfo;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.StringUtil;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.animal.horse.Horse;
import net.minecraft.world.entity.npc.Npc;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.scores.PlayerTeam;

public class EntityDTO
implements Serializable {
    public final String entityId;
    public transient WeakReference<LivingEntity> entityLivingRef;
    public transient ResourceLocation entityIconLocation;
    public String iconLocation;
    public Boolean hostile;
    public double posX;
    public double posY;
    public double posZ;
    public int chunkCoordX;
    public int chunkCoordY;
    public int chunkCoordZ;
    public double heading;
    public String customName;
    public String owner;
    public String profession;
    public String username;
    public String biome;
    public ResourceKey<Level> dimension;
    public Boolean underground;
    public boolean invisible;
    public boolean sneaking;
    public boolean passiveAnimal;
    public boolean npc;
    public int color;

    private EntityDTO(LivingEntity entity) {
        this.entityLivingRef = new WeakReference<LivingEntity>(entity);
        this.entityId = entity.m_142081_().toString();
    }

    public void update(LivingEntity entity, boolean hostile) {
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer currentPlayer = Minecraft.m_91087_().f_91074_;
        this.dimension = DimensionHelper.getDimension((Entity)entity);
        this.posX = entity.m_20185_();
        this.posY = entity.m_20186_();
        this.posZ = entity.m_20189_();
        this.chunkCoordX = entity.m_146902_().f_45578_;
        this.chunkCoordY = entity.m_146904_() >> 4;
        this.chunkCoordZ = entity.m_146902_().f_45579_;
        this.heading = Math.round(entity.m_146908_() % 360.0f);
        this.invisible = currentPlayer != null ? entity.m_20177_((Player)currentPlayer) : false;
        this.sneaking = entity.m_6144_();
        CoreProperties coreProperties = JourneymapClient.getInstance().getCoreProperties();
        ResourceLocation entityIcon = null;
        int playerColor = coreProperties.getColor(coreProperties.colorPlayer);
        PlayerTeam team = null;
        try {
            team = mc.f_91073_.m_6188_().m_83500_(entity.m_20149_());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (entity instanceof Player) {
            String name;
            this.username = name = StringUtil.m_14406_((String)entity.m_7755_().getString());
            try {
                playerColor = team != null ? team.m_7414_().m_126656_() : (currentPlayer.equals((Object)entity) ? coreProperties.getColor(coreProperties.colorSelf) : coreProperties.getColor(coreProperties.colorPlayer));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            entityIcon = DefaultPlayerSkin.m_118626_();
            try {
                ClientPacketListener client = Minecraft.m_91087_().m_91403_();
                PlayerInfo info = client.m_104949_(entity.m_142081_());
                if (info != null) {
                    entityIcon = info.m_105337_();
                }
            }
            catch (Throwable t) {
                Journeymap.getLogger().error("Error looking up player skin: " + LogFormatter.toPartialString(t));
            }
        } else {
            this.username = null;
            entityIcon = EntityHelper.getIconTextureLocation((Entity)entity);
        }
        if (entityIcon != null) {
            this.entityIconLocation = entityIcon;
            this.iconLocation = entityIcon.toString();
        }
        String owner = null;
        if (entity instanceof TamableAnimal) {
            LivingEntity ownerEntity = ((TamableAnimal)entity).m_142480_();
            if (ownerEntity != null) {
                owner = ownerEntity.m_7755_().getString();
            }
        } else if (entity instanceof Horse) {
            UUID ownerUuid = ((Horse)entity).m_30615_();
            if (currentPlayer != null && ownerUuid != null) {
                try {
                    String playerUuid = currentPlayer.m_142081_().toString();
                    if (playerUuid.equals(ownerUuid.toString())) {
                        owner = currentPlayer.m_7755_().getString();
                    }
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
        }
        this.owner = owner;
        String customName = null;
        boolean passive = false;
        if (entity instanceof LivingEntity) {
            LivingEntity attackTarget;
            LivingEntity entityLiving = entity;
            if (entity.m_8077_() && entityLiving.m_6052_()) {
                customName = StringUtil.m_14406_((String)entity.m_7770_().getString());
            }
            if (!hostile && currentPlayer != null && (attackTarget = entity.m_21232_()) != null && attackTarget.m_142081_().equals(currentPlayer.m_142081_())) {
                hostile = true;
            }
            if (EntityHelper.isPassive(entity)) {
                passive = true;
            }
        }
        if (entity instanceof Villager) {
            Villager villager = (Villager)entity;
            this.profession = villager.m_7141_().m_35571_().m_35622_().getRegistryName().m_135815_();
        } else if (entity instanceof Npc) {
            this.npc = true;
            this.profession = null;
            this.passiveAnimal = false;
        } else {
            this.profession = null;
            this.passiveAnimal = passive;
        }
        this.customName = customName;
        this.hostile = hostile;
        this.color = entity instanceof Player ? playerColor : (team != null ? team.m_7414_().m_126656_() : (!Strings.isNullOrEmpty((String)owner) ? coreProperties.getColor(coreProperties.colorPet) : (this.profession != null || this.npc ? coreProperties.getColor(coreProperties.colorVillager) : (hostile ? coreProperties.getColor(coreProperties.colorHostile) : coreProperties.getColor(coreProperties.colorPassive)))));
    }

    public static class SimpleCacheLoader
    extends CacheLoader<LivingEntity, EntityDTO> {
        public EntityDTO load(LivingEntity entity) throws Exception {
            return new EntityDTO(entity);
        }
    }
}

