/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.render.draw;

import com.google.common.cache.CacheLoader;
import com.mojang.blaze3d.vertex.PoseStack;
import java.awt.geom.Point2D;
import java.lang.ref.WeakReference;
import journeymap.client.JourneymapClient;
import journeymap.client.data.DataCache;
import journeymap.client.render.draw.DrawStep;
import journeymap.client.render.draw.DrawUtil;
import journeymap.client.render.map.GridRenderer;
import journeymap.client.render.texture.TextureImpl;
import journeymap.client.ui.minimap.EntityDisplay;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.scores.PlayerTeam;
import net.minecraft.world.scores.Team;

public class DrawEntityStep
implements DrawStep {
    static final Integer labelBg = 0;
    static final int labelBgAlpha = 180;
    static final Integer labelFg = 0xFFFFFF;
    static final int labelFgAlpha = 225;
    boolean useDots;
    int elevationOffset;
    int color;
    boolean hideSneaks;
    boolean hideSpectators;
    boolean showHeading = true;
    boolean showName = true;
    Minecraft minecraft = Minecraft.m_91087_();
    TextureImpl entityTexture;
    TextureImpl locatorTexture;
    WeakReference<LivingEntity> entityLivingRef;
    String customName;
    String playerTeamName;
    Point2D screenPosition;
    float drawScale = 1.0f;

    private DrawEntityStep(LivingEntity entityLiving) {
        this.entityLivingRef = new WeakReference<LivingEntity>(entityLiving);
        this.hideSneaks = JourneymapClient.getInstance().getCoreProperties().hideSneakingEntities.get();
        this.hideSpectators = JourneymapClient.getInstance().getCoreProperties().hideSpectators.get();
    }

    public void update(EntityDisplay entityDisplay, TextureImpl locatorTexture, TextureImpl entityTexture, int color, boolean showHeading, boolean showName, float entityDrawScale) {
        LivingEntity entityLiving = (LivingEntity)this.entityLivingRef.get();
        if (showName && entityLiving != null) {
            this.customName = DataCache.INSTANCE.getEntityDTO((LivingEntity)entityLiving).customName;
        }
        this.useDots = entityDisplay.isDots();
        this.color = color;
        this.locatorTexture = locatorTexture;
        this.entityTexture = entityTexture;
        this.drawScale = entityDrawScale;
        this.showHeading = showHeading;
        this.showName = showName;
        if (entityLiving instanceof Player) {
            Team team = entityLiving.m_5647_();
            this.playerTeamName = team != null && showName ? PlayerTeam.m_83348_((Team)entityLiving.m_5647_(), (Component)entityLiving.m_7755_()).getString() : null;
        }
    }

    @Override
    public void draw(PoseStack mStack, MultiBufferSource buffers, DrawStep.Pass pass, double xOffset, double yOffset, GridRenderer gridRenderer, double fontScale, double rotation) {
        if (pass == DrawStep.Pass.Tooltip) {
            return;
        }
        LivingEntity entityLiving = (LivingEntity)this.entityLivingRef.get();
        if (pass == DrawStep.Pass.Object) {
            if (entityLiving == null || !entityLiving.m_6084_() || entityLiving.m_20177_((Player)this.minecraft.f_91074_) || !entityLiving.isAddedToWorld() || this.hideSneaks && entityLiving.m_6144_() || this.hideSpectators && entityLiving.m_5833_()) {
                this.screenPosition = null;
                return;
            }
            this.screenPosition = gridRenderer.getPixel(entityLiving.m_20185_(), entityLiving.m_20189_());
        }
        if (this.screenPosition != null) {
            double heading = entityLiving.m_146908_();
            double drawX = this.screenPosition.getX() + xOffset;
            double drawY = this.screenPosition.getY() + yOffset;
            float alpha = 1.0f;
            if (entityLiving.m_20186_() > this.minecraft.f_91074_.m_20186_()) {
                alpha = 1.0f - Math.max(0.1f, (float)((entityLiving.m_20186_() - this.minecraft.f_91074_.m_20186_()) / 32.0));
            }
            if (entityLiving instanceof Player) {
                this.drawPlayer(mStack, pass, buffers, drawX, drawY, gridRenderer, alpha, heading, fontScale, rotation);
            } else {
                this.drawCreature(mStack, pass, buffers, drawX, drawY, gridRenderer, alpha, heading, fontScale, rotation);
            }
        }
    }

    private void drawPlayer(PoseStack mStack, DrawStep.Pass pass, MultiBufferSource buffers, double drawX, double drawY, GridRenderer gridRenderer, float alpha, double heading, double fontScale, double rotation) {
        LivingEntity entityLiving = (LivingEntity)this.entityLivingRef.get();
        if (entityLiving == null) {
            return;
        }
        if (pass == DrawStep.Pass.Object) {
            if (this.locatorTexture != null) {
                DrawUtil.drawColoredEntity(mStack, drawX, drawY, this.locatorTexture, this.color, alpha, this.drawScale, this.showHeading ? heading : -rotation);
            }
            if (this.entityTexture != null) {
                if (this.useDots) {
                    boolean flip = false;
                    this.elevationOffset = (int)(DataCache.getPlayer().posY - entityLiving.m_20186_());
                    if (this.elevationOffset < -1 || this.elevationOffset > 1) {
                        flip = this.elevationOffset < -1;
                        DrawUtil.drawColoredEntity(mStack, drawX, drawY, this.entityTexture, this.color, alpha, this.drawScale, flip ? -rotation + 180.0 : -rotation);
                    }
                } else {
                    DrawUtil.drawColoredEntity(mStack, drawX, drawY, this.entityTexture, this.color, alpha, this.drawScale, -rotation);
                }
            }
        }
        if (pass == DrawStep.Pass.Text) {
            int labelOffset = this.entityTexture == null ? 0 : (rotation == 0.0 ? -this.entityTexture.getHeight() / 2 : this.entityTexture.getHeight() / 2);
            Point2D labelPoint = gridRenderer.shiftWindowPosition((int)drawX, (int)drawY, 0, -labelOffset);
            if (this.playerTeamName != null && this.showName) {
                DrawUtil.drawBatchLabel(mStack, this.playerTeamName, buffers, labelPoint.getX(), labelPoint.getY(), DrawUtil.HAlign.Center, DrawUtil.VAlign.Below, 0, 0.8f, 0xFFFFFF, 1.0f, fontScale, false, rotation);
            } else if (this.showName) {
                DrawUtil.drawBatchLabel(mStack, entityLiving.m_7755_().getString(), buffers, labelPoint.getX(), labelPoint.getY(), DrawUtil.HAlign.Center, DrawUtil.VAlign.Below, 0, 0.8f, 65280, 1.0f, fontScale, false, rotation);
            }
        }
    }

    private void drawCreature(PoseStack mStack, DrawStep.Pass pass, MultiBufferSource buffers, double drawX, double drawY, GridRenderer gridRenderer, float alpha, double heading, double fontScale, double rotation) {
        int labelOffset;
        LivingEntity entityLiving = (LivingEntity)this.entityLivingRef.get();
        if (entityLiving == null) {
            return;
        }
        if (pass == DrawStep.Pass.Object && this.locatorTexture != null) {
            DrawUtil.drawColoredEntity(mStack, drawX, drawY, this.locatorTexture, this.color, alpha, this.drawScale, this.showHeading ? heading : -rotation);
        }
        int n = this.entityTexture == null ? 8 : (labelOffset = rotation == 0.0 ? this.entityTexture.getHeight() : -this.entityTexture.getHeight());
        if (pass == DrawStep.Pass.Text && this.showName && this.customName != null) {
            Point2D labelPoint = gridRenderer.shiftWindowPosition(drawX, drawY, 0, labelOffset);
            DrawUtil.drawBatchLabel(mStack, this.customName, buffers, labelPoint.getX(), labelPoint.getY(), DrawUtil.HAlign.Center, DrawUtil.VAlign.Middle, labelBg, 180.0f, 0xFFFFFF, 225.0f, fontScale, false, rotation);
        }
        if (pass == DrawStep.Pass.Object && this.entityTexture != null) {
            if (this.useDots) {
                boolean flip = false;
                this.elevationOffset = (int)(DataCache.getPlayer().posY - entityLiving.m_20186_());
                if (this.elevationOffset < -1 || this.elevationOffset > 1) {
                    flip = this.elevationOffset < -1;
                    DrawUtil.drawColoredEntity(mStack, drawX, drawY, this.entityTexture, this.color, alpha, this.drawScale, flip ? -rotation + 180.0 : -rotation);
                }
            } else {
                DrawUtil.drawEntity(mStack, drawX, drawY, -rotation, this.entityTexture, alpha, this.drawScale, 0.0);
            }
        }
    }

    @Override
    public int getDisplayOrder() {
        return this.customName != null ? 1 : 0;
    }

    @Override
    public String getModId() {
        return "journeymap";
    }

    public static class SimpleCacheLoader
    extends CacheLoader<LivingEntity, DrawEntityStep> {
        public DrawEntityStep load(LivingEntity entityLiving) throws Exception {
            return new DrawEntityStep(entityLiving);
        }
    }
}

