/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.render.draw;

import com.mojang.blaze3d.vertex.PoseStack;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Locale;
import java.util.concurrent.Future;
import journeymap.client.api.display.ImageOverlay;
import journeymap.client.api.model.MapImage;
import journeymap.client.api.model.TextProperties;
import journeymap.client.render.draw.BaseOverlayDrawStep;
import journeymap.client.render.draw.DrawStep;
import journeymap.client.render.draw.DrawUtil;
import journeymap.client.render.map.GridRenderer;
import journeymap.client.render.texture.TextureCache;
import journeymap.client.render.texture.TextureImpl;
import journeymap.common.Journeymap;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.resources.ResourceLocation;

public class DrawImageStep
extends BaseOverlayDrawStep<ImageOverlay> {
    private Point2D.Double northWestPosition;
    private Point2D.Double southEastPosition;
    private volatile Future<TextureImpl> iconFuture;
    private TextureImpl iconTexture;
    private boolean hasError;

    public DrawImageStep(ImageOverlay marker) {
        super(marker);
    }

    @Override
    public void draw(PoseStack mStack, MultiBufferSource buffers, DrawStep.Pass pass, double xOffset, double yOffset, GridRenderer gridRenderer, double fontScale, double rotation) {
        if (!this.isOnScreen(xOffset, yOffset, gridRenderer, rotation)) {
            return;
        }
        if (pass == DrawStep.Pass.Object) {
            this.ensureTexture();
            if (!this.hasError && this.iconTexture != null) {
                MapImage icon = ((ImageOverlay)this.overlay).getImage();
                double width = this.screenBounds.width;
                double height = this.screenBounds.height;
                DrawUtil.drawColoredSprite(mStack, this.iconTexture, width, height, 0.0, 0.0, icon.getDisplayWidth(), icon.getDisplayHeight(), icon.getColor(), icon.getOpacity(), this.northWestPosition.x + xOffset, this.northWestPosition.y + yOffset, 1.0f, icon.getRotation());
            }
        } else {
            super.drawText(mStack, pass, xOffset, yOffset, gridRenderer, fontScale, rotation);
        }
    }

    protected void ensureTexture() {
        if (this.iconTexture != null) {
            return;
        }
        try {
            if (this.iconFuture == null || this.iconFuture.isCancelled()) {
                this.iconFuture = TextureCache.scheduleTextureTask(() -> {
                    MapImage image = ((ImageOverlay)this.overlay).getImage();
                    ResourceLocation resourceLocation = image.getImageLocation();
                    if (resourceLocation == null) {
                        resourceLocation = new ResourceLocation("fake", ((ImageOverlay)this.overlay).getGuid().toLowerCase(Locale.ROOT));
                        TextureImpl texture = TextureCache.getTexture(resourceLocation);
                        texture.setImage(image.getImage(), true);
                        return texture;
                    }
                    return TextureCache.getTexture(resourceLocation);
                });
            } else if (this.iconFuture.isDone()) {
                this.iconTexture = this.iconFuture.get();
                if (this.iconTexture.isBindNeeded()) {
                    this.iconTexture.m_117966_();
                }
                this.iconFuture = null;
            }
        }
        catch (Exception e) {
            Journeymap.getLogger().error("Error getting ImageOverlay marimage upperTexture: " + e, (Throwable)e);
            this.hasError = true;
        }
    }

    @Override
    protected void updatePositions(GridRenderer gridRenderer, double rotation) {
        this.northWestPosition = gridRenderer.getBlockPixelInGrid(((ImageOverlay)this.overlay).getNorthWestPoint());
        this.southEastPosition = gridRenderer.getBlockPixelInGrid(((ImageOverlay)this.overlay).getSouthEastPoint());
        this.screenBounds = new Rectangle2D.Double(this.northWestPosition.x, this.northWestPosition.y, 0.0, 0.0);
        this.screenBounds.add(this.southEastPosition);
        TextProperties textProperties = ((ImageOverlay)this.overlay).getTextProperties();
        this.labelPosition.setLocation(this.screenBounds.getCenterX() + (double)textProperties.getOffsetX(), this.screenBounds.getCenterY() + (double)textProperties.getOffsetY());
    }
}

