/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.render.draw;

import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Matrix3f;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3f;
import java.util.Objects;
import journeymap.client.cartography.color.RGB;
import journeymap.client.render.RenderWrapper;
import journeymap.client.render.draw.DrawUtil;
import journeymap.client.render.texture.TextureImpl;
import journeymap.common.Journeymap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.OverlayTexture;

public class MatrixDrawUtil {
    public static int zLevel = 0;

    public static void drawColoredImage(TextureImpl texture, PoseStack mStack, VertexConsumer vertexBuilder, int color, float alpha, double x, double y, double rotation) {
        MatrixDrawUtil.drawQuad(mStack, vertexBuilder, color, alpha, x, y, texture.getWidth(), texture.getHeight(), false, rotation);
    }

    public static void drawQuad(PoseStack mStack, VertexConsumer vertexBuilder, int color, float alpha, double x, double y, double width, double height, boolean flip, double rotation) {
        MatrixDrawUtil.drawQuad(mStack, vertexBuilder, color, alpha, x, y, width, height, 0.0, 0.0, 1.0, 1.0, rotation, flip, true, 770, 771, false);
    }

    public static void drawLabel(String text, PoseStack mStack, MultiBufferSource buffers, double x, double y, DrawUtil.HAlign hAlign, DrawUtil.VAlign vAlign, Integer bgColor, float bgAlpha, int color, float alpha, double fontScale, boolean fontShadow) {
        double bgWidth = 0.0;
        double bgHeight = 0.0;
        if (bgColor != null && bgAlpha > 0.0f) {
            Font fontRenderer = Minecraft.m_91087_().f_91062_;
            bgWidth = fontRenderer.m_92895_(text);
            bgHeight = DrawUtil.getLabelHeight(fontRenderer, fontShadow);
        }
        MatrixDrawUtil.drawLabel(text, mStack, buffers, x, y, hAlign, vAlign, bgColor, bgAlpha, bgWidth, bgHeight, color, alpha, fontScale, fontShadow, 0);
    }

    private static void drawLabel(String text, PoseStack mStack, MultiBufferSource buffers, double x, double y, DrawUtil.HAlign hAlign, DrawUtil.VAlign vAlign, Integer bgColor, float bgAlpha, double bgWidth, double bgHeight, int color, float alpha, double fontScale, boolean fontShadow, int rotation) {
        double d;
        int height;
        if (text == null || text.length() == 0) {
            return;
        }
        Font fontRenderer = Minecraft.m_91087_().f_91062_;
        boolean drawRect = bgColor != null && bgAlpha > 0.0f;
        double width = fontRenderer.m_92895_(text);
        if (drawRect) {
            v0 = DrawUtil.getLabelHeight(fontRenderer, fontShadow);
        } else {
            Objects.requireNonNull(fontRenderer);
            v0 = height = 9;
        }
        if (!drawRect && fontRenderer.m_92718_()) {
            --height;
        }
        mStack.m_85836_();
        if (fontScale != 1.0) {
            x /= fontScale;
            y /= fontScale;
            mStack.m_85841_((float)fontScale, (float)fontScale, 0.0f);
        }
        float textX = (float)x;
        float textY = (float)y;
        double rectX = x;
        double rectY = y;
        switch (hAlign) {
            case Left: {
                textX = (float)(x - width);
                rectX = textX;
                break;
            }
            case Center: {
                textX = (float)(x - width / 2.0 + (fontScale > 1.0 ? 0.5 : 0.0));
                rectX = (float)(x - Math.max(1.0, bgWidth) / 2.0 + (fontScale > 1.0 ? 0.5 : 0.0));
                break;
            }
            case Right: {
                textX = (float)x;
                rectX = (float)x;
            }
        }
        if (drawRect) {
            Objects.requireNonNull(fontRenderer);
            d = (double)(height - 9) / 2.0;
        } else {
            d = 0.0;
        }
        double vpad = d;
        switch (vAlign) {
            case Above: {
                rectY = y - (double)height;
                textY = (float)(rectY + vpad + (double)(!fontRenderer.m_92718_() ? 1 : 0));
                break;
            }
            case Middle: {
                rectY = y - (double)(height / 2) + (fontScale > 1.0 ? 0.5 : 0.0);
                textY = (float)(rectY + vpad);
                break;
            }
            case Below: {
                rectY = y;
                textY = (float)(rectY + vpad);
            }
        }
        if (rotation != 0) {
            mStack.m_85837_(x, y, 0.0);
            mStack.m_85845_(Vector3f.f_122227_.m_122240_((float)(-rotation)));
            mStack.m_85837_(-x, -y, 0.0);
        }
        Matrix4f matrixPos = mStack.m_85850_().m_85861_();
        if (drawRect) {
            int backgroundColor = Minecraft.m_91087_().f_91066_.m_92170_(bgAlpha);
            int hpad = 2;
            MatrixDrawUtil.drawRectangle(matrixPos, rectX - 2.0 - 0.5, rectY, bgWidth + 4.0, bgHeight, backgroundColor);
        }
        if (alpha < 0.0f) {
            color = RGB.toArbg(color, alpha);
        }
        mStack.m_85837_((double)textX - Math.floor(textX), (double)textY - Math.floor(textY), 0.0);
        fontRenderer.m_92811_(text, textX, textY, color, fontShadow, matrixPos, buffers, true, 0, 0xF000F0);
        RenderWrapper.disableDepthTest();
        RenderWrapper.depthMask(false);
        mStack.m_85849_();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void drawQuad(PoseStack mStack, VertexConsumer vertexBuilder, int color, float alpha, double x, double y, double width, double height, double minU, double minV, double maxU, double maxV, double rotation, boolean flip, boolean blend, int glBlendSfactor, int glBlendDFactor, boolean clampTexture) {
        try {
            mStack.m_85836_();
            if (alpha > 1.0f) {
                alpha /= 255.0f;
            }
            if (rotation != 0.0) {
                double transX = x + width / 2.0;
                double transY = y + height / 2.0;
                mStack.m_85837_(transX, transY, 0.0);
                mStack.m_85845_(Vector3f.f_122227_.m_122240_((float)(-rotation)));
                mStack.m_85837_(-transX, -transY, 0.0);
            }
            float[] rgba = RGB.floats(color, alpha);
            float direction = (float)(flip ? -maxU : maxU);
            PoseStack.Pose entry = mStack.m_85850_();
            Matrix4f matrix4f = entry.m_85861_();
            Matrix3f matrix3f = entry.m_85864_();
            RenderWrapper.depthMask(true);
            RenderWrapper.enableDepthTest();
            MatrixDrawUtil.addVertexUV(matrix4f, matrix3f, vertexBuilder, rgba[0], rgba[1], rgba[2], rgba[3], (int)(height + y), (float)x, zLevel, (float)minU, (float)maxV);
            MatrixDrawUtil.addVertexUV(matrix4f, matrix3f, vertexBuilder, rgba[0], rgba[1], rgba[2], rgba[3], (int)(height + y), (float)(x + width), zLevel, direction, (float)maxV);
            MatrixDrawUtil.addVertexUV(matrix4f, matrix3f, vertexBuilder, rgba[0], rgba[1], rgba[2], rgba[3], (int)y, (float)(x + width), zLevel, direction, (float)minV);
            MatrixDrawUtil.addVertexUV(matrix4f, matrix3f, vertexBuilder, rgba[0], rgba[1], rgba[2], rgba[3], (int)y, (float)x, zLevel, (float)minU, (float)minV);
            RenderWrapper.disableDepthTest();
            RenderWrapper.depthMask(false);
        }
        catch (Exception e) {
            Journeymap.getLogger().error((Object)e);
        }
        finally {
            mStack.m_85849_();
        }
    }

    public static void addBufferedVertexWithUV(BufferBuilder bufferIn, double x, double y, double z, double texU, double texV) {
        bufferIn.m_5483_(x, y, z).m_7421_((float)texU, (float)texV).m_5752_();
    }

    public static void drawRectangle(Matrix4f matrixPos, double x, double y, double width, double height, int color) {
        MatrixDrawUtil.fill(matrixPos, (int)x, (int)y, (int)(x + width), (int)(height + y), color);
    }

    public static void fill(Matrix4f matrixPos, int x, int y, int bottomX, int bottomY, int color) {
        if (x < bottomX) {
            int i = x;
            x = bottomX;
            bottomX = i;
        }
        if (y < bottomY) {
            int j = y;
            y = bottomY;
            bottomY = j;
        }
        float f3 = (float)(color >> 24 & 0xFF) / 255.0f;
        float f = (float)(color >> 16 & 0xFF) / 255.0f;
        float f1 = (float)(color >> 8 & 0xFF) / 255.0f;
        float f2 = (float)(color & 0xFF) / 255.0f;
        BufferBuilder bufferbuilder = Tesselator.m_85913_().m_85915_();
        RenderWrapper.enableBlend();
        RenderWrapper.disableTexture();
        RenderWrapper.setShader(GameRenderer::m_172811_);
        RenderWrapper.blendFuncSeparate(770, 771, 1, 0);
        bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        bufferbuilder.m_85982_(matrixPos, (float)x, (float)bottomY, 0.0f).m_85950_(f, f1, f2, f3).m_5752_();
        bufferbuilder.m_85982_(matrixPos, (float)bottomX, (float)bottomY, 0.0f).m_85950_(f, f1, f2, f3).m_5752_();
        bufferbuilder.m_85982_(matrixPos, (float)bottomX, (float)y, 0.0f).m_85950_(f, f1, f2, f3).m_5752_();
        bufferbuilder.m_85982_(matrixPos, (float)x, (float)y, 0.0f).m_85950_(f, f1, f2, f3).m_5752_();
        bufferbuilder.m_85721_();
        BufferUploader.m_85761_((BufferBuilder)bufferbuilder);
        RenderWrapper.setColor4f(1.0f, 1.0f, 1.0f, 1.0f);
        RenderWrapper.enableTexture();
        RenderWrapper.disableBlend();
    }

    public static void addVertexUVOverlay(Matrix4f matrixPos, Matrix3f matrixNormal, VertexConsumer bufferIn, float red, float green, float blue, float alpha, int y, float x, float z, float texU, float texV, int overlayUV) {
        bufferIn.m_85982_(matrixPos, x, (float)y, z).m_85950_(red, green, blue, alpha).m_7421_(texU, texV).m_86008_(overlayUV).m_85969_(0xF000F0).m_85977_(matrixNormal, 0.0f, 1.0f, 0.0f).m_5752_();
    }

    public static void addVertexUV(Matrix4f matrixPos, Matrix3f matrixNormal, VertexConsumer bufferIn, float red, float green, float blue, float alpha, int y, float x, float z, float texU, float texV) {
        bufferIn.m_85982_(matrixPos, x, (float)y, z).m_85950_(red, green, blue, alpha).m_7421_(texU, texV).m_86008_(OverlayTexture.f_118083_).m_85969_(0xF000F0).m_85977_(matrixNormal, 0.0f, 1.0f, 0.0f).m_5752_();
    }

    public static void addVertex(Matrix4f matrixPos, Matrix3f matrixNormal, VertexConsumer bufferIn, float red, float green, float blue, float alpha, double x, double y, float z) {
        bufferIn.m_85982_(matrixPos, (float)x, (float)y, z).m_85950_(red, green, blue, alpha).m_85977_(matrixNormal, 0.0f, 1.0f, 0.0f).m_5752_();
    }
}

