/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.render.ingame;

import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix3f;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3f;
import java.util.Collection;
import journeymap.client.Constants;
import journeymap.client.JourneymapClient;
import journeymap.client.cartography.color.RGB;
import journeymap.client.properties.WaypointProperties;
import journeymap.client.render.RenderWrapper;
import journeymap.client.render.draw.DrawUtil;
import journeymap.client.render.draw.MatrixDrawUtil;
import journeymap.client.render.ingame.WaypointRenderTypes;
import journeymap.client.waypoint.Waypoint;
import journeymap.client.waypoint.WaypointStore;
import journeymap.common.Journeymap;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;

public class WaypointRenderer {
    private WaypointProperties waypointProperties;
    private Minecraft minecraft = Minecraft.m_91087_();
    private EntityRenderDispatcher renderManager = this.minecraft.m_91290_();
    private static WaypointRenderer INSTANCE;

    private WaypointRenderer() {
    }

    public static WaypointRenderer getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new WaypointRenderer();
        }
        return INSTANCE;
    }

    public void renderAllWaypoints(PoseStack mStack) {
        RenderTarget worldRendererFramebuffer;
        this.waypointProperties = JourneymapClient.getInstance().getWaypointProperties();
        Collection<Waypoint> waypoints = WaypointStore.INSTANCE.getAll();
        String playerDim = this.minecraft.f_91074_.f_19853_.m_46472_().m_135782_().toString();
        MultiBufferSource.BufferSource buffers = this.minecraft.m_91269_().m_110104_();
        RenderWrapper.enableBlend();
        RenderWrapper.defaultBlendFunc();
        RenderWrapper.enableDepthTest();
        RenderWrapper.enableTexture();
        RenderWrapper.depthMask(false);
        if (Minecraft.m_91085_() && (worldRendererFramebuffer = this.minecraft.f_91060_.m_109828_()) != null) {
            RenderTarget framebuffer = this.minecraft.m_91385_();
            RenderWrapper.bindFramebuffer(36008, worldRendererFramebuffer.f_83920_);
            RenderWrapper.bindFramebuffer(36009, framebuffer.f_83920_);
            RenderWrapper.blitFramebuffer(0, 0, worldRendererFramebuffer.f_83915_, worldRendererFramebuffer.f_83916_, 0, 0, framebuffer.f_83915_, framebuffer.f_83916_, 256, 9728);
        }
        for (Waypoint waypoint : waypoints) {
            if (!waypoint.isEnable() || !waypoint.getDimensions().contains(playerDim)) continue;
            try {
                mStack.m_85851_();
                mStack.m_85836_();
                this.render(waypoint, mStack, (MultiBufferSource)buffers);
                mStack.m_85849_();
            }
            catch (Exception t) {
                Journeymap.getLogger().error("EntityWaypoint failed to render for " + waypoint + ": ", (Throwable)t);
            }
        }
        buffers.m_109911_();
        RenderWrapper.depthMask(true);
    }

    private void render(Waypoint waypoint, PoseStack mStack, MultiBufferSource buffers) {
        float partialTicks = this.minecraft.m_91296_();
        long gameTime = this.minecraft.f_91073_.m_46467_();
        float fadeAlpha = 1.0f;
        Vec3 waypointVec = waypoint.getPosition().m_82520_(0.0, 0.118, 0.0);
        Vec3 playerVec = this.minecraft.f_91074_.m_20182_();
        double actualDistance = playerVec.m_82554_(waypointVec);
        int maxDistance = this.waypointProperties.maxDistance.get();
        int minDistance = this.waypointProperties.minDistance.get();
        float[] rgba = RGB.floats(waypoint.getColor(), fadeAlpha * 0.4f);
        double viewX = this.renderManager.f_114358_.m_90583_().m_7096_();
        double viewY = this.renderManager.f_114358_.m_90583_().m_7098_();
        double viewZ = this.renderManager.f_114358_.m_90583_().m_7094_();
        boolean showStaticInnerBeam = this.waypointProperties.showStaticBeam.get();
        boolean showRotatingOuterBeam = this.waypointProperties.showRotatingBeam.get();
        double viewDistance = actualDistance;
        double maxRenderDistance = this.minecraft.f_91066_.f_92106_ * 16;
        if (maxDistance > 0 && actualDistance > (double)maxDistance) {
            return;
        }
        if (waypoint.isDeathPoint() && this.waypointProperties.autoRemoveDeathpoints.get().booleanValue() && actualDistance < (double)this.waypointProperties.autoRemoveDeathpointDistance.get().intValue() && actualDistance > 1.5) {
            Journeymap.getLogger().debug("Auto removing deathpoint " + waypoint);
            WaypointStore.INSTANCE.remove(waypoint);
            return;
        }
        if (minDistance > 0) {
            if ((int)actualDistance <= minDistance) {
                return;
            }
            if ((int)actualDistance <= minDistance + 4) {
                fadeAlpha = Math.min((float)(actualDistance - (double)minDistance) / 3.0f, 1.0f);
            }
        }
        if (viewDistance > maxRenderDistance) {
            Vec3 delta = waypointVec.m_82546_(playerVec).m_82541_();
            waypointVec = playerVec.m_82520_(delta.f_82479_ * maxRenderDistance, delta.f_82480_ * maxRenderDistance, delta.f_82481_ * maxRenderDistance);
            viewDistance = maxRenderDistance;
        }
        double scale = 0.00390625 * ((viewDistance + 4.0) / 3.0);
        double shiftX = waypointVec.f_82479_ - viewX;
        double shiftY = waypointVec.f_82480_ - viewY;
        double shiftZ = waypointVec.f_82481_ - viewZ;
        if (showStaticInnerBeam || showRotatingOuterBeam) {
            mStack.m_85836_();
            mStack.m_85837_(shiftX, -180.0, shiftZ);
            WaypointRenderer.renderBeamSegment(mStack, buffers, partialTicks, gameTime, 1, 360, rgba, 0.2f, 0.25f, showStaticInnerBeam, showRotatingOuterBeam);
            mStack.m_85849_();
        }
        if (this.lookingAtBeacon(waypointVec) && viewDistance > 0.5) {
            mStack.m_85836_();
            this.renderNameTag(waypoint, mStack, buffers, fadeAlpha, scale, actualDistance, shiftX, shiftY, shiftZ);
            mStack.m_85849_();
        }
        if (this.lookingAtBeacon(waypointVec) && viewDistance > 0.5 && waypoint.showDeviation() && this.waypointProperties.showDeviationLabel.get().booleanValue()) {
            mStack.m_85836_();
            this.renderDeviation(waypoint, mStack, buffers, fadeAlpha, scale, shiftX, shiftY, shiftZ, playerVec, waypointVec);
            mStack.m_85849_();
        }
        if (viewDistance > 0.1 && this.waypointProperties.showTexture.get().booleanValue()) {
            mStack.m_85836_();
            this.renderIcon(waypoint, mStack, buffers, fadeAlpha, scale, shiftX, shiftY, shiftZ);
            mStack.m_85849_();
        }
    }

    private void renderIcon(Waypoint waypoint, PoseStack mStack, MultiBufferSource buffers, float alpha, double scale, double shiftX, double shiftY, double shiftZ) {
        int n = this.waypointProperties.textureSmall.get() != false ? 2 : 4;
        mStack.m_85836_();
        mStack.m_85837_(shiftX, shiftY, shiftZ);
        mStack.m_85845_(this.renderManager.f_114358_.m_90591_());
        mStack.m_85841_((float)(-(scale *= (double)n)), (float)(-scale), (float)scale);
        VertexConsumer vertexBuilder = buffers.m_6299_(WaypointRenderTypes.getIcon(waypoint.getTextureResource()));
        RenderWrapper.setShader(GameRenderer::m_172814_);
        RenderWrapper.setShaderTexture(0, waypoint.getTexture().m_117963_());
        MatrixDrawUtil.drawColoredImage(waypoint.getTexture(), mStack, vertexBuilder, waypoint.getColor(), alpha, (double)(-(waypoint.getTexture().getWidth() >> 1)) + 0.5, (double)(-(waypoint.getTexture().getHeight() >> 1)) + 0.2, 0.0);
        mStack.m_85849_();
    }

    private void renderDeviation(Waypoint waypoint, PoseStack mStack, MultiBufferSource buffers, float alpha, double scale, double shiftX, double shiftY, double shiftZ, Vec3 playerVec, Vec3 waypointVec) {
        StringBuilder sb = new StringBuilder();
        Vec3 vecTo = playerVec.m_82505_(waypointVec);
        if (this.waypointProperties.boldLabel.get().booleanValue()) {
            sb.append(ChatFormatting.BOLD);
        }
        sb.append(String.format("x:%d, y:%d, z:%d", (int)vecTo.f_82479_, (int)vecTo.f_82480_, (int)vecTo.f_82481_));
        double labelY = (waypoint.getTexture().getHeight() >> 1) + 35;
        this.renderWaypointLabel(sb.toString(), waypoint, labelY, mStack, buffers, alpha, scale, shiftX, shiftY, shiftZ);
    }

    private void renderNameTag(Waypoint waypoint, PoseStack mStack, MultiBufferSource buffers, float alpha, double scale, double actualDistance, double shiftX, double shiftY, double shiftZ) {
        String distanceLabel = Constants.getString("jm.waypoint.distance_meters", "%1.0f");
        String label = waypoint.getName();
        boolean showName = this.waypointProperties.showName.get() != false && label != null && label.length() > 0;
        boolean showDistance = this.waypointProperties.showDistance.get();
        if (showName || showDistance) {
            StringBuilder sb = new StringBuilder();
            if (this.waypointProperties.boldLabel.get().booleanValue()) {
                sb.append(ChatFormatting.BOLD);
            }
            if (showName) {
                sb.append(label);
            }
            if (showName && showDistance) {
                sb.append(" ");
            }
            if (showDistance) {
                sb.append(String.format(distanceLabel, actualDistance));
            }
            if (sb.length() > 0) {
                label = sb.toString();
                double labelY = -(waypoint.getTexture().getHeight() >> 1) - 8;
                this.renderWaypointLabel(label, waypoint, labelY, mStack, buffers, alpha, scale, shiftX, shiftY, shiftZ);
            }
        }
    }

    private void renderWaypointLabel(String label, Waypoint waypoint, double labelY, PoseStack mStack, MultiBufferSource buffers, float alpha, double scale, double shiftX, double shiftY, double shiftZ) {
        mStack.m_85836_();
        mStack.m_85837_(shiftX, shiftY, shiftZ);
        mStack.m_85845_(this.renderManager.f_114358_.m_90591_());
        mStack.m_85841_((float)(-scale), (float)(-scale), (float)scale);
        float fontScale = this.waypointProperties.fontScale.get().floatValue();
        MatrixDrawUtil.drawLabel(label, mStack, buffers, 1.0, labelY, DrawUtil.HAlign.Center, DrawUtil.VAlign.Above, -16777216, 0.6f * alpha, waypoint.getSafeColor(), alpha, fontScale, false);
        MatrixDrawUtil.drawLabel(label, mStack, buffers, 1.0, labelY, DrawUtil.HAlign.Center, DrawUtil.VAlign.Above, -16777216, 0.4f * alpha, waypoint.getSafeColor(), alpha, fontScale, false);
        mStack.m_85849_();
    }

    private boolean lookingAtBeacon(Vec3 waypointVec) {
        if (this.waypointProperties.autoHideLabel.get().booleanValue()) {
            double playerYaw;
            int angle = 5;
            double yaw = Math.atan2(this.renderManager.f_114358_.m_90583_().m_7094_() - waypointVec.f_82481_, this.renderManager.f_114358_.m_90583_().m_7096_() - waypointVec.f_82479_);
            double degrees = Math.toDegrees(yaw) + 90.0;
            if (degrees < 0.0) {
                degrees = 360.0 + degrees;
            }
            if ((playerYaw = (double)(this.minecraft.f_91075_.m_6080_() % 360.0f)) < 0.0) {
                playerYaw += 360.0;
            }
            playerYaw = Math.toRadians(playerYaw);
            double playerDegrees = Math.toDegrees(playerYaw);
            return !(Math.abs((degrees += (double)angle) + (double)angle - ((playerDegrees += (double)angle) + (double)angle)) > (double)angle);
        }
        return true;
    }

    public static void renderBeamSegment(PoseStack mStack, MultiBufferSource buffer, float partialTicks, long gameTime, int yOffset, int height, float[] colors, float beamRadius, float glowRadius, boolean showStaticInnerBeam, boolean showRotatingOuterBeam) {
        float texScale = 1.0f;
        int heightOffset = yOffset + height;
        float rotation = (float)Math.floorMod(gameTime, 40L) + partialTicks;
        float texOffset = -((float)(-gameTime) * 0.2f - (float)Mth.m_14143_((float)((float)(-gameTime) * 0.1f))) * 0.6f;
        float red = colors[0];
        float blue = colors[1];
        float green = colors[2];
        float alpha = colors[3];
        VertexConsumer beamBuffer = buffer.m_6299_(WaypointRenderTypes.getBeam());
        mStack.m_85836_();
        if (!showStaticInnerBeam) {
            mStack.m_85845_(Vector3f.f_122225_.m_122240_(rotation * 2.25f - 45.0f));
        }
        float V2 = -1.0f + texOffset;
        float innerV1 = (float)height * texScale * (0.5f / beamRadius) + V2;
        WaypointRenderer.renderPart(mStack, beamBuffer, red, blue, green, alpha, yOffset, heightOffset, 0.0f, beamRadius, beamRadius, 0.0f, -beamRadius, 0.0f, 0.0f, -beamRadius, 0.0f, 1.0f, innerV1, V2);
        mStack.m_85849_();
        float outerV1 = (float)height * texScale + V2;
        mStack.m_85836_();
        if (showRotatingOuterBeam) {
            mStack.m_85845_(Vector3f.f_122225_.m_122240_(rotation * 2.25f - 45.0f));
        }
        WaypointRenderer.renderPart(mStack, beamBuffer, red, blue, green, alpha, yOffset, heightOffset, -glowRadius, -glowRadius, glowRadius, -glowRadius, -glowRadius, glowRadius, glowRadius, glowRadius, 0.0f, 1.0f, outerV1, V2);
        mStack.m_85849_();
    }

    private static void renderPart(PoseStack mStack, VertexConsumer buffer, float red, float green, float blue, float alpha, int yMin, int yMax, float p1, float p2, float p3, float p4, float p5, float p6, float p7, float p8, float u1, float u2, float v1, float v2) {
        PoseStack.Pose entry = mStack.m_85850_();
        Matrix4f matrixPos = entry.m_85861_();
        Matrix3f normal = entry.m_85864_();
        WaypointRenderer.addQuad(matrixPos, normal, buffer, red, green, blue, alpha, yMin, yMax, p1, p2, p3, p4, u1, u2, v1, v2);
        WaypointRenderer.addQuad(matrixPos, normal, buffer, red, green, blue, alpha, yMin, yMax, p7, p8, p5, p6, u1, u2, v1, v2);
        WaypointRenderer.addQuad(matrixPos, normal, buffer, red, green, blue, alpha, yMin, yMax, p3, p4, p7, p8, u1, u2, v1, v2);
        WaypointRenderer.addQuad(matrixPos, normal, buffer, red, green, blue, alpha, yMin, yMax, p5, p6, p1, p2, u1, u2, v1, v2);
    }

    private static void addQuad(Matrix4f matrixPos, Matrix3f normal, VertexConsumer bufferIn, float red, float green, float blue, float alpha, int yMin, int yMax, float x1, float z1, float x2, float z2, float u1, float u2, float v1, float v2) {
        MatrixDrawUtil.addVertexUV(matrixPos, normal, bufferIn, red, green, blue, alpha, yMax, x1, z1, u2, v1);
        MatrixDrawUtil.addVertexUV(matrixPos, normal, bufferIn, red, green, blue, alpha, yMin, x1, z1, u2, v2);
        MatrixDrawUtil.addVertexUV(matrixPos, normal, bufferIn, red, green, blue, alpha, yMin, x2, z2, u1, v2);
        MatrixDrawUtil.addVertexUV(matrixPos, normal, bufferIn, red, green, blue, alpha, yMax, x2, z2, u1, v1);
    }
}

