/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.render.texture;

import com.google.common.base.MoreObjects;
import com.mojang.blaze3d.platform.TextureUtil;
import java.awt.image.BufferedImage;
import java.lang.ref.WeakReference;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;
import journeymap.client.log.JMLogger;
import journeymap.client.render.RenderWrapper;
import journeymap.client.render.texture.TextureCache;
import journeymap.client.task.main.ExpireTextureTask;
import journeymap.client.task.multi.MapPlayerTask;
import journeymap.common.Journeymap;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import org.lwjgl.BufferUtils;

public class TextureImpl
extends AbstractTexture {
    protected final ReentrantLock bufferLock = new ReentrantLock();
    protected BufferedImage image;
    protected boolean retainImage;
    protected int width;
    protected int height;
    protected float alpha;
    protected long lastImageUpdate;
    protected long lastBound;
    protected String description;
    protected ResourceLocation resourceLocation;
    protected List<WeakReference<Listener>> listeners = new ArrayList<WeakReference<Listener>>(0);
    protected ByteBuffer buffer;
    protected IntBuffer intBuffer;
    protected boolean bindNeeded;

    public TextureImpl(ResourceLocation resourceLocation) {
        this(null, TextureCache.resolveImage(resourceLocation), false, false);
        this.resourceLocation = resourceLocation;
        this.setDescription(resourceLocation.m_135815_());
    }

    public TextureImpl(BufferedImage image) {
        this(null, image, false, true);
    }

    public TextureImpl(BufferedImage image, boolean retainImage) {
        this(null, image, retainImage, true);
    }

    public TextureImpl(Integer glId, BufferedImage image, boolean retainImage) {
        this(glId, image, retainImage, true);
    }

    public TextureImpl(Integer glId, BufferedImage image, boolean retainImage, boolean bindImmediately) {
        if (glId != null) {
            this.f_117950_ = glId;
        }
        this.retainImage = retainImage;
        if (image != null) {
            this.setImage(image, retainImage);
        }
        if (bindImmediately) {
            this.m_117966_();
            this.buffer = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setImage(BufferedImage bufferedImage, boolean retainImage) {
        if (bufferedImage == null) {
            return;
        }
        try {
            this.bufferLock.lock();
            this.retainImage = retainImage;
            if (retainImage) {
                this.image = bufferedImage;
            }
            this.width = bufferedImage.getWidth();
            this.height = bufferedImage.getHeight();
            int bufferSize = this.width * this.height * 4;
            if (this.buffer == null || this.buffer.capacity() != bufferSize) {
                this.intBuffer = BufferUtils.createByteBuffer((int)bufferSize).asIntBuffer();
            }
            TextureImpl.loadIntBuffer(bufferedImage, this.intBuffer);
            this.bindNeeded = true;
        }
        finally {
            this.bufferLock.unlock();
        }
        this.lastImageUpdate = System.currentTimeMillis();
        this.notifyListeners();
    }

    public static void loadByteBuffer(BufferedImage bufferedImage, ByteBuffer buffer) {
        int width = bufferedImage.getWidth();
        int height = bufferedImage.getHeight();
        buffer.clear();
        int[] pixels = new int[width * height];
        bufferedImage.getRGB(0, 0, width, height, pixels, 0, width);
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                int pixel = pixels[y * width + x];
                buffer.put((byte)(pixel >> 16 & 0xFF));
                buffer.put((byte)(pixel >> 8 & 0xFF));
                buffer.put((byte)(pixel & 0xFF));
                buffer.put((byte)(pixel >> 24 & 0xFF));
            }
        }
        buffer.flip();
    }

    public static IntBuffer loadIntBuffer(BufferedImage bufferedImage, IntBuffer ib) {
        int width = bufferedImage.getWidth();
        int height = bufferedImage.getHeight();
        ib.clear();
        int[] array = new int[width * height];
        bufferedImage.getRGB(0, 0, width, height, array, 0, width);
        ib.put(array);
        ib.flip();
        return ib;
    }

    public void m_117966_() {
        if (!this.bindNeeded) {
            return;
        }
        if (this.bufferLock.tryLock()) {
            if (this.f_117950_ > -1) {
                MapPlayerTask.addTempDebugMessage("tex" + this.f_117950_, "Updating: " + this.getDescription());
            }
            try {
                int glErr;
                this.f_117950_ = super.m_117963_();
                RenderWrapper.bindTextureForSetup(this.f_117950_);
                RenderWrapper.activeTexture(33984);
                TextureUtil.m_85305_((IntBuffer)this.intBuffer, (int)this.width, (int)this.height);
                RenderWrapper.setShader(GameRenderer::m_172817_);
                RenderWrapper.setShaderTexture(0, this.f_117950_);
                this.bindNeeded = false;
                while ((glErr = RenderWrapper.getError()) != 0) {
                    JMLogger.logOnce("GL Error in TextureImpl after initTexture: " + glErr + " in " + this, null);
                    this.bindNeeded = true;
                }
                if (!this.bindNeeded) {
                    this.lastBound = System.currentTimeMillis();
                }
            }
            catch (Throwable t) {
                Journeymap.getLogger().warn("Can't bind texture: ", t);
                this.buffer = null;
            }
            finally {
                this.bufferLock.unlock();
            }
        }
    }

    public boolean isBindNeeded() {
        return this.bindNeeded;
    }

    public boolean isBound() {
        return this.f_117950_ != -1;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void updateAndBind(BufferedImage image) {
        this.updateAndBind(image, this.retainImage);
    }

    public void updateAndBind(BufferedImage image, boolean retainImage) {
        this.setImage(image, retainImage);
        this.m_117966_();
    }

    public boolean hasImage() {
        return this.image != null;
    }

    public BufferedImage getImage() {
        if (this.image != null) {
            return this.image;
        }
        if (this.resourceLocation != null) {
            return TextureCache.resolveImage(this.resourceLocation);
        }
        return null;
    }

    public boolean isDefunct() {
        return this.f_117950_ == -1 && this.image == null && this.buffer == null;
    }

    public int m_117963_() {
        if (this.bindNeeded) {
            this.m_117966_();
        }
        return super.m_117963_();
    }

    public int getGlTextureId(boolean forceBind) {
        if (forceBind || this.f_117950_ == -1) {
            return this.m_117963_();
        }
        return this.f_117950_;
    }

    public void clear() {
        this.bufferLock.lock();
        this.buffer = null;
        this.bufferLock.unlock();
        this.image = null;
        this.bindNeeded = false;
        this.lastImageUpdate = 0L;
        this.lastBound = 0L;
        this.f_117950_ = -1;
    }

    public void queueForDeletion() {
        ExpireTextureTask.queue(this);
    }

    public long getLastImageUpdate() {
        return this.lastImageUpdate;
    }

    public long getLastBound() {
        return this.lastBound;
    }

    public void m_6704_(ResourceManager par1ResourceManager) {
        if (this.resourceLocation != null) {
            // empty if block
        }
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("glid", this.f_117950_).add("description", (Object)this.description).add("lastImageUpdate", this.lastImageUpdate).add("lastBound", this.lastBound).toString();
    }

    public void close() {
        if (this.isBound()) {
            ExpireTextureTask.queue(this.f_117950_);
            super.close();
        }
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public float getAlpha() {
        return this.alpha;
    }

    public void setAlpha(float alpha) {
        this.alpha = alpha;
    }

    public void addListener(Listener addedListener) {
        Iterator<WeakReference<Listener>> iter = this.listeners.iterator();
        while (iter.hasNext()) {
            WeakReference<Listener> ref = iter.next();
            Listener listener = (Listener)ref.get();
            if (listener == null) {
                iter.remove();
                continue;
            }
            if (addedListener != listener) continue;
            return;
        }
        this.listeners.add(new WeakReference<Listener>(addedListener));
    }

    protected void notifyListeners() {
        Iterator<WeakReference<Listener>> iter = this.listeners.iterator();
        while (iter.hasNext()) {
            WeakReference<Listener> ref = iter.next();
            Listener listener = (Listener)ref.get();
            if (listener == null) {
                iter.remove();
                continue;
            }
            listener.textureImageUpdated(this);
        }
    }

    public static interface Listener<T extends TextureImpl> {
        public void textureImageUpdated(T var1);
    }
}

