/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.service.webmap.kotlin.routes;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import info.journeymap.shaded.kotlin.kotlin.Metadata;
import info.journeymap.shaded.kotlin.kotlin.Pair;
import info.journeymap.shaded.kotlin.kotlin.TuplesKt;
import info.journeymap.shaded.kotlin.kotlin.collections.MapsKt;
import info.journeymap.shaded.kotlin.kotlin.jvm.internal.Intrinsics;
import info.journeymap.shaded.kotlin.spark.kotlin.RouteHandler;
import info.journeymap.shaded.org.jetbrains.annotations.NotNull;
import java.util.ArrayList;
import java.util.List;
import journeymap.client.api.display.Context;
import journeymap.client.api.display.Overlay;
import journeymap.client.api.display.PolygonOverlay;
import journeymap.client.api.impl.ClientAPI;
import journeymap.client.api.model.MapPolygon;
import journeymap.client.api.util.UIState;
import journeymap.client.cartography.color.RGB;
import journeymap.client.render.draw.DrawPolygonStep;
import journeymap.client.render.draw.OverlayDrawStep;
import net.minecraft.core.BlockPos;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000\u0014\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"GSON", "Lcom/google/gson/Gson;", "polygonsGet", "", "handler", "Linfo/journeymap/shaded/kotlin/spark/kotlin/RouteHandler;", "journeymap"})
public final class PolygonsKt {
    @NotNull
    private static final Gson GSON;

    @NotNull
    public static final Object polygonsGet(@NotNull RouteHandler handler) {
        UIState uiState;
        Intrinsics.checkNotNullParameter(handler, "handler");
        boolean bl = false;
        List data = new ArrayList();
        boolean bl2 = false;
        List steps = new ArrayList();
        UIState fullscreenState = ClientAPI.INSTANCE.getUIState(Context.UI.Fullscreen);
        UIState minimapState = ClientAPI.INSTANCE.getUIState(Context.UI.Minimap);
        Object object = fullscreenState;
        UIState uIState = uiState = (object == null ? false : !((UIState)object).active) && ((object = minimapState) == null ? false : ((UIState)object).active) ? minimapState : fullscreenState;
        Intrinsics.checkNotNull(uIState);
        ClientAPI.INSTANCE.getDrawSteps(steps, uIState);
        for (OverlayDrawStep step : steps) {
            Pair[] pairArray;
            if (!(step instanceof DrawPolygonStep)) continue;
            Overlay overlay = ((DrawPolygonStep)step).overlay;
            if (overlay == null) {
                throw new NullPointerException("null cannot be cast to non-null type journeymap.client.api.display.PolygonOverlay");
            }
            PolygonOverlay polygon = (PolygonOverlay)overlay;
            boolean bl3 = false;
            List points = new ArrayList();
            List<BlockPos> list = polygon.getOuterArea().getPoints();
            Intrinsics.checkNotNullExpressionValue(list, "polygon.outerArea.points");
            Iterable $this$forEach$iv = list;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                BlockPos point = (BlockPos)element$iv;
                boolean bl4 = false;
                pairArray = new Pair[]{TuplesKt.to("x", point.m_123341_()), TuplesKt.to("y", point.m_123342_()), TuplesKt.to("z", point.m_123343_())};
                points.add(MapsKt.mapOf(pairArray));
            }
            boolean bl5 = false;
            List holes = new ArrayList();
            if (polygon.getHoles() != null) {
                for (MapPolygon hole : polygon.getHoles()) {
                    boolean bl6 = false;
                    List holePoints = new ArrayList();
                    for (BlockPos holePoint : hole.getPoints()) {
                        pairArray = new Pair[]{TuplesKt.to("x", holePoint.m_123341_()), TuplesKt.to("y", holePoint.m_123342_()), TuplesKt.to("z", holePoint.m_123343_())};
                        holePoints.add(MapsKt.mapOf(pairArray));
                    }
                    holes.add(holePoints);
                }
            }
            Pair[] pairArray2 = new Pair[]{TuplesKt.to("fillColor", RGB.toHexString(polygon.getShapeProperties().getFillColor())), TuplesKt.to("fillOpacity", Float.valueOf(polygon.getShapeProperties().getFillOpacity())), TuplesKt.to("strokeColor", RGB.toHexString(polygon.getShapeProperties().getStrokeColor())), TuplesKt.to("strokeOpacity", Float.valueOf(polygon.getShapeProperties().getStrokeOpacity())), TuplesKt.to("strokeWidth", Float.valueOf(polygon.getShapeProperties().getStrokeWidth())), TuplesKt.to("holes", holes), TuplesKt.to("points", points)};
            data.add(MapsKt.mapOf(pairArray2));
        }
        handler.getResponse().raw().setContentType("application/json");
        object = GSON.toJson((Object)data);
        Intrinsics.checkNotNullExpressionValue(object, "GSON.toJson(data)");
        return object;
    }

    static {
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        Intrinsics.checkNotNullExpressionValue(gson, "GsonBuilder().setPrettyPrinting().create()");
        GSON = gson;
    }
}

