/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.ui.component;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import journeymap.client.render.draw.DrawUtil;
import journeymap.client.ui.component.Button;
import journeymap.client.ui.component.DropDownItem;
import journeymap.client.ui.component.ScrollPane;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;

public class DropDownButton
extends Button {
    private static final int MAX_DISPLAY_SIZE = 6;
    private ScrollPane scrollPane;
    private boolean visible = false;
    private DropDownItem selected;
    protected List<DropDownItem> items;
    protected int paneWidth;
    protected Button.OnPress f_93717_;
    protected String glyphClosed = "\u25b6";
    protected String glyphDown = "\u25bc";
    protected String glyphUp = "\u25b2";

    public DropDownButton(String label, Button.OnPress onPress) {
        super(label, DropDownButton.emptyPressable());
        this.f_93717_ = onPress;
    }

    public void setItems(List<DropDownItem> items) {
        this.items = items;
        this.paneWidth = this.m_5711_();
        this.scrollPane = new ScrollPane(null, Minecraft.m_91087_(), 0, 0, items, items.get(0).m_93694_(), 2);
        this.scrollPane.setDrawPartialScrollable(false);
        this.scrollPane.m_93471_(false);
    }

    @Override
    public boolean m_6375_(double mouseX, double mouseY, int button) {
        this.scrollPane.m_6375_(mouseX, mouseY, button);
        Button pressed = this.scrollPane.mouseClicked((int)mouseX, (int)mouseX, button);
        this.scrollPane.f_93399_ = false;
        boolean mouseOver = this.scrollPane.m_5953_(mouseX, mouseY);
        if (mouseOver) {
            this.scrollPane.m_93481_(mouseX, mouseY, button);
        }
        if ((this.visible && pressed == null && !mouseOver || !this.isEnabled() && pressed != null) && !this.scrollPane.f_93399_) {
            this.visible = false;
            this.setEnabled(true);
            return true;
        }
        if (mouseOver) {
            return true;
        }
        boolean buttonClicked = super.m_6375_(mouseX, mouseY, button);
        if (buttonClicked && !this.visible) {
            this.visible = true;
            this.setEnabled(false);
            return true;
        }
        return buttonClicked;
    }

    public boolean mouseOverPane(double x, double y) {
        return this.scrollPane.m_5953_(x, y);
    }

    public boolean m_6050_(double x, double y, double scroll) {
        if (this.scrollPane.m_5953_(x, y)) {
            return this.scrollPane.m_6050_(x, y, scroll);
        }
        return super.m_6050_(x, y, scroll);
    }

    public boolean m_6348_(double mouseX, double mouseY, int mouseButton) {
        this.scrollPane.m_6348_(mouseX, mouseY, mouseButton);
        return super.m_6348_(mouseX, mouseY, mouseButton);
    }

    @Override
    public boolean m_5702_() {
        return super.m_5702_();
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double mouseDX, double mouseDY) {
        this.scrollPane.m_7979_(mouseX, mouseY, button, mouseDX, mouseDY);
        return super.m_7979_(mouseX, mouseY, button, mouseDX, mouseDY);
    }

    public void m_94757_(double mouseX, double mouseY) {
        this.scrollPane.m_94757_(mouseX, mouseY);
        super.m_94757_(mouseX, mouseY);
    }

    public boolean m_7920_(int keyCode, int scanCode, int modifiers) {
        this.scrollPane.m_7920_(keyCode, scanCode, modifiers);
        return super.m_7920_(keyCode, scanCode, modifiers);
    }

    @Override
    public void m_6305_(PoseStack mStack, int mouseX, int mouseY, float partialTicks) {
        if (this.visible) {
            this.scrollPane.setDimensions(this.paneWidth - 6, this.getPaneHeight(), 0, 0, this.f_93620_ + 2, this.f_93621_ - this.scrollPane.paneHeight - 10);
            this.scrollPane.m_6305_(mStack, mouseX, mouseY, partialTicks);
        }
        DrawUtil.drawLabel(mStack, this.visible ? this.glyphUp : this.glyphClosed, this.getX() + 16, this.getMiddleY() - 1, DrawUtil.HAlign.Left, DrawUtil.VAlign.Middle, 0, 0.0f, this.visible ? this.disabledLabelColor : this.getLabelColor(), this.visible ? 0.25f : 1.0f, 1.5, true);
        super.m_6305_(mStack, mouseX, mouseY, partialTicks);
    }

    private int getPaneHeight() {
        int size = Math.min(this.items.size(), 6);
        return size * (this.items.get(0).m_93694_() + 5);
    }

    public int m_5711_() {
        int width = 0;
        if (this.items != null) {
            Font fontRenderer = Minecraft.m_91087_().f_91062_;
            for (DropDownItem item : this.items) {
                int newWidth = fontRenderer.m_92895_(item.getLabel());
                if (newWidth <= width) continue;
                width = newWidth;
            }
            this.f_93618_ = width + 50;
        }
        return this.f_93618_;
    }

    public void setSelected(DropDownItem selected) {
        this.selected = selected;
        this.f_93717_.m_93750_((net.minecraft.client.gui.components.Button)selected);
        this.m_93666_((Component)new TextComponent(selected.getLabel()));
    }

    public DropDownItem getSelected() {
        return this.selected;
    }

    public String getSelectedLabel() {
        return this.selected.getLabel();
    }
}

