/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.ui.component;

import com.mojang.blaze3d.vertex.PoseStack;
import java.math.BigDecimal;
import journeymap.client.Constants;
import journeymap.client.render.RenderWrapper;
import journeymap.client.ui.component.Button;
import journeymap.client.ui.component.IConfigFieldHolder;
import journeymap.client.ui.component.SliderButton;
import journeymap.common.properties.config.FloatField;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.fmlclient.gui.GuiUtils;

public class FloatSliderButton
extends Button
implements IConfigFieldHolder<FloatField>,
SliderButton {
    public String prefix = "";
    public boolean dragging = false;
    public float minValue = 0.0f;
    public float maxValue = 0.0f;
    public String suffix = "";
    public boolean drawString = true;
    private float incrementValue = 0.1f;
    private int precision = 2;
    FloatField field;

    public FloatSliderButton(FloatField field, String prefix, String suf) {
        this(field, prefix, suf, field.getMinValue(), field.getMaxValue());
    }

    public FloatSliderButton(FloatField field, String prefix, String suf, float minVal, float maxVal) {
        super(prefix);
        this.minValue = minVal;
        this.maxValue = maxVal;
        this.prefix = prefix;
        this.suffix = suf;
        this.field = field;
        this.setValue(field.get().floatValue());
        this.disabledLabelColor = 0x404040;
    }

    public FloatSliderButton(FloatField field, String prefix, String suf, float minVal, float maxVal, float incrementValue, int precision) {
        super(prefix);
        this.minValue = minVal;
        this.maxValue = maxVal;
        this.prefix = prefix;
        this.suffix = suf;
        this.field = field;
        this.setValue(field.get().floatValue());
        this.disabledLabelColor = 0x404040;
    }

    protected int m_7202_(boolean p_getYImage_1_) {
        return 0;
    }

    protected void m_7906_(PoseStack mStack, Minecraft mc, int mouseX, int mouseY) {
        double sliderValue = this.getSliderValue();
        RenderWrapper.setShader(GameRenderer::m_172817_);
        GuiUtils.drawContinuousTexturedBox((PoseStack)mStack, (ResourceLocation)f_93617_, (int)(this.f_93620_ + 1 + (int)(sliderValue * (double)(this.f_93618_ - 10))), (int)(this.f_93621_ + 1), (int)0, (int)66, (int)8, (int)(this.f_93619_ - 2), (int)200, (int)20, (int)2, (int)3, (int)2, (int)2, (float)this.m_93252_());
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double mouseDX, double mouseDY) {
        if (this.f_93624_ && this.isEnabled() && this.m_5953_(mouseX, mouseY) && this.dragging) {
            this.setValueFromMouse(mouseX);
            if (this.clickListeners != null) {
                this.checkClickListeners();
            }
            return true;
        }
        return false;
    }

    private void setValueFromMouse(double mouseX) {
        this.setSliderValue((mouseX - (double)(this.f_93620_ + 4)) / (double)(this.f_93618_ - 8));
    }

    @Override
    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (this.mouseOver(mouseX, mouseY)) {
            this.dragging = true;
            this.setValueFromMouse(mouseX);
            this.checkClickListeners();
            return true;
        }
        return false;
    }

    public double getSliderValue() {
        return (this.field.get().floatValue() - this.minValue) / (this.maxValue - this.minValue);
    }

    public void setSliderValue(double sliderValue) {
        float val = (float)sliderValue * (this.maxValue - this.minValue) + this.minValue;
        this.setValue(val);
    }

    @Override
    public void updateLabel() {
        if (this.drawString) {
            this.m_93666_((Component)Constants.getStringTextComponent(this.prefix + this.field.get() + this.suffix));
        }
    }

    public boolean m_6348_(double mouseX, double mouseY, int mouseButton) {
        this.dragging = false;
        this.field.save();
        this.checkClickListeners();
        return super.m_6348_(mouseX, mouseY, mouseButton);
    }

    @Override
    public int getFitWidth(Font fr) {
        int max = fr.m_92895_(this.prefix + this.minValue + this.suffix);
        max = Math.max(max, fr.m_92895_(this.prefix + this.maxValue + this.suffix));
        return max + this.WIDTH_PAD;
    }

    public boolean m_7933_(int key, int value, int modifier) {
        if (this.isEnabled()) {
            if (key == 263 || key == 264 || key == 45) {
                this.setValue(Math.max(this.minValue, this.getValue() - this.incrementValue));
                return true;
            }
            if (key == 262 || key == 265 || key == 61) {
                this.setValue(Math.min(this.maxValue, this.getValue() + this.incrementValue));
                return true;
            }
        }
        return false;
    }

    public float getValue() {
        return this.field.get().floatValue();
    }

    public void setValue(float value) {
        float roundedValue = new BigDecimal(value).setScale(this.precision, 4).floatValue();
        roundedValue = Math.min(roundedValue, this.maxValue);
        roundedValue = Math.max(roundedValue, this.minValue);
        if (this.field.get().floatValue() != roundedValue) {
            this.field.set(Float.valueOf(roundedValue));
            if (!this.dragging) {
                this.field.save();
            }
        }
        this.updateLabel();
    }

    @Override
    public void refresh() {
        this.setValue(this.field.get().floatValue());
    }

    @Override
    public FloatField getConfigField() {
        return this.field;
    }
}

