/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.ui.component;

import com.mojang.blaze3d.vertex.PoseStack;
import journeymap.client.Constants;
import journeymap.client.render.RenderWrapper;
import journeymap.client.ui.component.Button;
import journeymap.client.ui.component.IConfigFieldHolder;
import journeymap.client.ui.component.SliderButton;
import journeymap.common.properties.config.IntegerField;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.fmlclient.gui.GuiUtils;

public class IntSliderButton
extends Button
implements IConfigFieldHolder<IntegerField>,
SliderButton {
    public String prefix = "";
    public boolean dragging = false;
    public int minValue = 0;
    public int maxValue = 0;
    public String suffix = "";
    public boolean drawString = true;
    IntegerField field;

    public IntSliderButton(IntegerField field, String prefix, String suf) {
        this(field, prefix, suf, field.getMinValue(), field.getMaxValue(), true);
    }

    public IntSliderButton(IntegerField field, String prefix, String suf, int minVal, int maxVal, boolean drawStr) {
        super(prefix);
        this.minValue = minVal;
        this.maxValue = maxVal;
        this.prefix = prefix;
        this.suffix = suf;
        this.field = field;
        this.setValue(field.get());
        this.disabledLabelColor = 0x404040;
    }

    protected int m_7202_(boolean p_getYImage_1_) {
        return 0;
    }

    protected void m_7906_(PoseStack mStack, Minecraft mc, int mouseX, int mouseY) {
        double sliderValue = this.getSliderValue();
        RenderWrapper.setShader(GameRenderer::m_172817_);
        GuiUtils.drawContinuousTexturedBox((PoseStack)mStack, (ResourceLocation)f_93617_, (int)(this.f_93620_ + 1 + (int)(sliderValue * (double)(this.f_93618_ - 10))), (int)(this.f_93621_ + 1), (int)0, (int)66, (int)8, (int)(this.f_93619_ - 2), (int)200, (int)20, (int)2, (int)3, (int)2, (int)2, (float)this.m_93252_());
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double mouseDX, double mouseDY) {
        if (this.f_93624_ && this.isEnabled() && this.m_5953_(mouseX, mouseY) && this.dragging) {
            this.setSliderValue((mouseX - (double)(this.f_93620_ + 4)) / (double)(this.f_93618_ - 8));
            if (this.clickListeners != null) {
                this.checkClickListeners();
            }
            return true;
        }
        return false;
    }

    private void setValueFromMouse(double mouseX) {
        this.setSliderValue((mouseX - (double)(this.f_93620_ + 4)) / (double)(this.f_93618_ - 8));
    }

    @Override
    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (this.mouseOver(mouseX, mouseY)) {
            this.dragging = true;
            this.setValueFromMouse(mouseX);
            this.checkClickListeners();
            return true;
        }
        return false;
    }

    public double getSliderValue() {
        return ((double)this.field.get().intValue() - (double)this.minValue * 1.0) / (double)(this.maxValue - this.minValue);
    }

    public void setSliderValue(double sliderValue) {
        if (sliderValue < 0.0) {
            sliderValue = 0.0;
        }
        if (sliderValue > 1.0) {
            sliderValue = 1.0;
        }
        int intVal = (int)Math.round(sliderValue * (double)(this.maxValue - this.minValue) + (double)this.minValue);
        this.setValue(intVal);
    }

    @Override
    public void updateLabel() {
        if (this.drawString) {
            this.m_93666_((Component)Constants.getStringTextComponent(this.prefix + this.field.get() + this.suffix));
        }
    }

    public boolean m_6348_(double mouseX, double mouseY, int mouseButton) {
        this.dragging = false;
        this.field.save();
        this.checkClickListeners();
        return super.m_6348_(mouseX, mouseY, mouseButton);
    }

    @Override
    public int getFitWidth(Font fr) {
        int max = fr.m_92895_(this.prefix + this.minValue + this.suffix);
        max = Math.max(max, fr.m_92895_(this.prefix + this.maxValue + this.suffix));
        return max + this.WIDTH_PAD;
    }

    public boolean m_7933_(int key, int value, int modifier) {
        if (this.isEnabled()) {
            if (key == 263 || key == 264 || key == 45) {
                this.setValue(Math.max(this.minValue, this.getValue() - 1));
                return true;
            }
            if (key == 262 || key == 265 || key == 61) {
                this.setValue(Math.min(this.maxValue, this.getValue() + 1));
                return true;
            }
        }
        return false;
    }

    public int getValue() {
        return this.field.get();
    }

    public void setValue(int value) {
        value = Math.min(value, this.maxValue);
        value = Math.max(value, this.minValue);
        if (this.field.get() != value) {
            this.field.set(value);
            if (!this.dragging) {
                this.field.save();
            }
        }
        this.updateLabel();
    }

    @Override
    public void refresh() {
        this.setValue(this.field.get());
    }

    @Override
    public IntegerField getConfigField() {
        return this.field;
    }
}

