/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.ui.component;

import com.mojang.blaze3d.vertex.PoseStack;
import java.awt.Color;
import journeymap.client.Constants;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.network.chat.Component;

public class TextBox
extends EditBox {
    protected final String numericRegex;
    protected final boolean numeric;
    protected final boolean allowNegative;
    protected int minLength;
    protected Integer clampMin;
    protected Integer clampMax;

    public TextBox(Object text, Font fontRenderer, int width, int height) {
        this(text, fontRenderer, width, height, false, false);
    }

    public TextBox(Object text, Font fontRenderer, int width, int height, boolean isNumeric, boolean negative) {
        super(fontRenderer, 0, 0, width, height, (Component)Constants.getStringTextComponent(text.toString()));
        this.m_94144_(text.toString());
        this.numeric = isNumeric;
        this.allowNegative = negative;
        String regex = null;
        if (this.numeric) {
            regex = this.allowNegative ? "[^-?\\d]" : "[^\\d]";
        }
        this.numericRegex = regex;
    }

    public void setClamp(Integer min, Integer max) {
        this.clampMin = min;
        this.clampMax = max;
    }

    public void setMinLength(int minLength) {
        this.minLength = minLength;
    }

    public void m_94164_(String par1Str) {
        super.m_94164_(par1Str);
        if (this.numeric) {
            Object fixed = this.m_94155_().replaceAll(this.numericRegex, "");
            if (this.allowNegative) {
                String start = ((String)fixed).startsWith("-") ? "-" : "";
                fixed = start + ((String)fixed).replaceAll("-", "");
            }
            super.m_94144_((String)fixed);
        }
    }

    public void setText(Object object) {
        super.m_94144_(object.toString());
    }

    public boolean isNumeric() {
        return this.numeric;
    }

    public boolean hasMinLength() {
        String text = this.m_94155_();
        int textLen = text == null ? 0 : text.length();
        return this.minLength <= textLen;
    }

    public boolean m_5534_(char c, int key) {
        if (this.numeric && this.m_93696_()) {
            this.clamp();
        }
        super.m_5534_(c, key);
        return true;
    }

    public boolean m_7933_(int key, int value, int modifier) {
        super.m_7933_(key, value, modifier);
        return true;
    }

    public void m_6305_(PoseStack mStack, int mouseX, int mouseY, float partialTicks) {
        super.m_6305_(mStack, mouseX, mouseY, partialTicks);
        if (this.m_94213_() && !this.hasMinLength()) {
            int red = Color.red.getRGB();
            int x1 = this.getX() - 1;
            int y1 = this.getY() - 1;
            int x2 = x1 + this.m_5711_() + 1;
            int y2 = y1 + this.m_93694_() + 1;
            TextBox.m_93172_((PoseStack)mStack, (int)x1, (int)y1, (int)x2, (int)(y1 + 1), (int)red);
            TextBox.m_93172_((PoseStack)mStack, (int)x1, (int)y2, (int)x2, (int)(y2 + 1), (int)red);
            TextBox.m_93172_((PoseStack)mStack, (int)x1, (int)y1, (int)(x1 + 1), (int)y2, (int)red);
            TextBox.m_93172_((PoseStack)mStack, (int)x2, (int)y1, (int)(x2 + 1), (int)y2, (int)red);
        }
    }

    public Integer clamp() {
        if (!this.numeric) {
            return null;
        }
        String text = this.m_94155_();
        if (this.clampMin != null) {
            if (text == null || text.length() == 0 || text.equals("-")) {
                return null;
            }
            try {
                this.setText(Math.max(this.clampMin, Integer.parseInt(text)));
            }
            catch (Exception e) {
                this.setText(this.clampMin);
            }
            if (this.clampMax != null) {
                try {
                    this.setText(Math.min(this.clampMax, Integer.parseInt(text)));
                }
                catch (Exception e) {
                    this.setText(this.clampMax);
                }
            }
        }
        try {
            return Integer.parseInt(text);
        }
        catch (Exception e) {
            return null;
        }
    }

    public int getX() {
        return this.f_93620_;
    }

    public void m_94214_(int x) {
        this.f_93620_ = x;
    }

    public int getY() {
        return this.f_93621_;
    }

    public void setY(int y) {
        this.f_93621_ = y;
    }

    public int m_5711_() {
        return this.f_93618_;
    }

    public void m_93674_(int w) {
        this.f_93618_ = w;
    }

    public int m_93694_() {
        return this.f_93619_;
    }

    public void setHeight(int h) {
        this.f_93619_ = h;
    }

    public int getCenterX() {
        return this.getX() + this.m_5711_() / 2;
    }

    public int getMiddleY() {
        return this.getY() + this.m_93694_() / 2;
    }

    public int getBottomY() {
        return this.getY() + this.m_93694_();
    }

    public int getRightX() {
        return this.getX() + this.m_5711_();
    }
}

