/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.ui.dialog;

import com.google.common.collect.Maps;
import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import journeymap.client.Constants;
import journeymap.client.InternalStateHandler;
import journeymap.client.JourneymapClient;
import journeymap.client.cartography.color.ColorManager;
import journeymap.client.data.DataCache;
import journeymap.client.forge.event.KeyEventHandler;
import journeymap.client.io.ThemeLoader;
import journeymap.client.log.ChatLog;
import journeymap.client.log.JMLogger;
import journeymap.client.mod.ModBlockDelegate;
import journeymap.client.model.BlockMD;
import journeymap.client.model.MapType;
import journeymap.client.properties.ClientCategory;
import journeymap.client.properties.CoreProperties;
import journeymap.client.properties.MiniMapProperties;
import journeymap.client.render.draw.DrawUtil;
import journeymap.client.render.map.TileDrawStepCache;
import journeymap.client.service.webmap.Webmap;
import journeymap.client.task.main.SoftResetTask;
import journeymap.client.task.multi.MapPlayerTask;
import journeymap.client.task.multi.RenderSpec;
import journeymap.client.ui.UIManager;
import journeymap.client.ui.component.Button;
import journeymap.client.ui.component.ButtonList;
import journeymap.client.ui.component.CheckBox;
import journeymap.client.ui.component.IConfigFieldHolder;
import journeymap.client.ui.component.IntSliderButton;
import journeymap.client.ui.component.JmUI;
import journeymap.client.ui.component.ResetButton;
import journeymap.client.ui.component.ScrollListPane;
import journeymap.client.ui.component.Slot;
import journeymap.client.ui.fullscreen.Fullscreen;
import journeymap.client.ui.minimap.MiniMap;
import journeymap.client.ui.minimap.Position;
import journeymap.client.ui.option.CategorySlot;
import journeymap.client.ui.option.OptionSlotFactory;
import journeymap.client.ui.option.SlotMetadata;
import journeymap.client.waypoint.WaypointStore;
import journeymap.common.Journeymap;
import journeymap.common.properties.PropertiesBase;
import journeymap.common.properties.catagory.Category;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.util.FormattedCharSequence;

public class OptionsManager
extends JmUI {
    protected static Set<Category> openCategories = new HashSet<Category>();
    protected final int inGameMinimapId;
    protected Category[] initialCategories;
    protected CheckBox minimap1PreviewButton;
    protected CheckBox minimap2PreviewButton;
    protected Button buttonClose;
    protected Button buttonAbout;
    protected Button buttonServer;
    protected Button renderStatsButton;
    protected Button editGridMinimap1Button;
    protected Button editGridMinimap2Button;
    protected Button editGridFullscreenButton;
    protected SlotMetadata renderStatsSlotMetadata;
    protected CategorySlot cartographyCategorySlot;
    protected ScrollListPane<CategorySlot> optionsListPane;
    protected Map<Category, List<SlotMetadata>> toolbars;
    protected Set<Category> changedCategories = new HashSet<Category>();
    protected boolean forceMinimapUpdate;
    protected ButtonList editGridButtons = new ButtonList();
    private boolean minimapDragging;
    private MiniMapProperties currentMiniMapProp;
    private MiniMap currentMiniMap;

    public OptionsManager() {
        this((Screen)null);
    }

    public OptionsManager(Screen returnDisplay) {
        this(returnDisplay, openCategories.toArray(new Category[0]));
    }

    public OptionsManager(Screen returnDisplay, Category ... initialCategories) {
        super(String.format("JourneyMap %s %s", Journeymap.JM_VERSION, Constants.getString("jm.common.options")), returnDisplay);
        this.initialCategories = initialCategories;
        this.inGameMinimapId = JourneymapClient.getInstance().getActiveMinimapId();
    }

    private Map<Category, PropertiesBase> getSlots() {
        HashMap slotMap = Maps.newHashMap();
        slotMap.put(ClientCategory.MiniMap1, JourneymapClient.getInstance().getMiniMapProperties1());
        slotMap.put(ClientCategory.MiniMap2, JourneymapClient.getInstance().getMiniMapProperties2());
        slotMap.put(ClientCategory.FullMap, JourneymapClient.getInstance().getFullMapProperties());
        slotMap.put(ClientCategory.WebMap, JourneymapClient.getInstance().getWebMapProperties());
        slotMap.put(ClientCategory.Waypoint, JourneymapClient.getInstance().getWaypointProperties());
        slotMap.put(ClientCategory.Advanced, JourneymapClient.getInstance().getCoreProperties());
        return slotMap;
    }

    @Override
    public void m_7856_() {
        try {
            Object tooltip;
            String name;
            this.f_169369_.clear();
            if (this.editGridMinimap1Button == null) {
                name = Constants.getString("jm.common.grid_edit");
                tooltip = Constants.getString("jm.common.grid_edit.tooltip");
                this.editGridMinimap1Button = new Button(name);
                this.editGridMinimap1Button.setTooltip(new String[]{tooltip});
                this.editGridMinimap1Button.setDrawBackground(false);
                this.editGridMinimap2Button = new Button(name);
                this.editGridMinimap2Button.setTooltip(new String[]{tooltip});
                this.editGridMinimap2Button.setDrawBackground(false);
                this.editGridFullscreenButton = new Button(name);
                this.editGridFullscreenButton.setTooltip(new String[]{tooltip});
                this.editGridFullscreenButton.setDrawBackground(false);
                this.editGridButtons = new ButtonList(this.editGridMinimap1Button, this.editGridMinimap2Button, this.editGridFullscreenButton);
            }
            if (this.minimap1PreviewButton == null) {
                name = String.format("%s %s", Constants.getString("jm.minimap.preview"), "1");
                tooltip = Constants.getString("jm.minimap.preview.tooltip", KeyEventHandler.getInstance().kbMinimapPreset.m_90863_());
                this.minimap1PreviewButton = new CheckBox(name, false);
                this.minimap1PreviewButton.setTooltip(new String[]{tooltip});
                if (Minecraft.m_91087_().f_91073_ == null) {
                    this.minimap1PreviewButton.setEnabled(false);
                }
            }
            if (this.minimap2PreviewButton == null) {
                name = String.format("%s %s", Constants.getString("jm.minimap.preview"), "2");
                tooltip = Constants.getString("jm.minimap.preview.tooltip", KeyEventHandler.getInstance().kbMinimapPreset.m_90863_());
                this.minimap2PreviewButton = new CheckBox(name, false);
                this.minimap2PreviewButton.setTooltip(new String[]{tooltip});
                if (Minecraft.m_91087_().f_91073_ == null) {
                    this.minimap2PreviewButton.setEnabled(false);
                }
            }
            if (this.renderStatsButton == null) {
                this.renderStatsButton = new LabelButton(150, "jm.common.renderstats", 0, 0, 0);
                this.renderStatsButton.setEnabled(false);
            }
            if (this.optionsListPane == null) {
                ArrayList<CategorySlot> categorySlots = new ArrayList<CategorySlot>();
                Objects.requireNonNull(this);
                this.optionsListPane = new ScrollListPane(this, this.f_96541_, this.f_96543_, this.f_96544_, 35, this.f_96544_ - 30, 20);
                this.optionsListPane.setAlignTop(true);
                this.optionsListPane.setSlots(OptionSlotFactory.getOptionSlots(this.getToolbars(), this.getSlots(), false));
                if (this.initialCategories != null) {
                    for (Category initialCategory : this.initialCategories) {
                        for (CategorySlot categorySlot : this.optionsListPane.getRootSlots()) {
                            if (categorySlot.getCategory() != initialCategory) continue;
                            categorySlot.setSelected(true);
                            categorySlots.add(categorySlot);
                        }
                    }
                }
                for (Slot slot : this.optionsListPane.getRootSlots()) {
                    if (!(slot instanceof CategorySlot)) continue;
                    CategorySlot categorySlot = (CategorySlot)slot;
                    Category category = categorySlot.getCategory();
                    if (category == ClientCategory.MiniMap1) {
                        if (Minecraft.m_91087_().f_91073_ != null) {
                            categorySlot.getAllChildMetadata().add(new SlotMetadata((Button)this.minimap1PreviewButton, 4));
                        }
                        categorySlot.getAllChildMetadata().add(new SlotMetadata(this.editGridMinimap1Button, 3));
                        continue;
                    }
                    if (category == ClientCategory.MiniMap2) {
                        if (Minecraft.m_91087_().f_91073_ != null) {
                            categorySlot.getAllChildMetadata().add(new SlotMetadata((Button)this.minimap2PreviewButton, 4));
                        }
                        categorySlot.getAllChildMetadata().add(new SlotMetadata(this.editGridMinimap2Button, 3));
                        continue;
                    }
                    if (category == ClientCategory.FullMap) {
                        categorySlot.getAllChildMetadata().add(new SlotMetadata(this.editGridMinimap2Button, 3));
                        continue;
                    }
                    if (category != ClientCategory.Cartography) continue;
                    this.cartographyCategorySlot = categorySlot;
                    this.renderStatsSlotMetadata = new SlotMetadata(this.renderStatsButton, Constants.getString("jm.common.renderstats.title"), Constants.getString("jm.common.renderstats.tooltip"), 2);
                }
                this.optionsListPane.updateSlots();
                if (!categorySlots.isEmpty()) {
                    this.optionsListPane.scrollTo((Slot)((Object)categorySlots.get(0)));
                }
            } else {
                this.optionsListPane.m_93437_(this.f_96543_, this.f_96544_, 35, this.f_96544_ - 30);
                this.optionsListPane.updateSlots();
            }
            this.buttonClose = (Button)this.m_142416_((GuiEventListener)new Button(Constants.getString("jm.common.close"), button -> this.closeAndReturn()));
            this.buttonAbout = (Button)this.m_142416_((GuiEventListener)new Button(Constants.getString("jm.common.splash_about"), button -> UIManager.INSTANCE.openSplash(this)));
            this.buttonServer = (Button)this.m_142416_((GuiEventListener)new Button(Constants.getString("jm.server.edit.label.admin.edit"), button -> UIManager.INSTANCE.openServerEditor(this)));
            InternalStateHandler stateHandler = JourneymapClient.getInstance().getStateHandler();
            this.buttonServer.setEnabled(stateHandler.canServerAdmin() || stateHandler.isReadOnlyServerAdmin());
            if (!stateHandler.canServerAdmin()) {
                boolean isAdmin = stateHandler.isServerAdmin();
                boolean bl = stateHandler.isJourneyMapServerConnection();
                if (!isAdmin && bl && !stateHandler.isReadOnlyServerAdmin()) {
                    this.buttonServer.setTooltip(Constants.getString("jm.server.button.no_permission.tooltip"));
                } else if (!bl) {
                    this.buttonServer.setTooltip(Constants.getString("jm.server.button.no_server.tooltip"));
                }
            }
            ButtonList bottomRow = new ButtonList(this.buttonAbout, this.buttonClose, this.buttonServer);
            bottomRow.equalizeWidths(this.getFontRenderer());
            bottomRow.setWidths(Math.max(150, this.buttonAbout.m_5711_()));
            bottomRow.layoutCenteredHorizontal(this.f_96543_ / 2, this.f_96544_ - 25, true, 4);
            this.f_169369_.addAll(bottomRow);
        }
        catch (Throwable t) {
            JMLogger.logOnce("Error in OptionsManager.init(): " + t, t);
        }
    }

    @Override
    protected void layoutButtons(PoseStack mStack) {
        if (this.f_169369_.isEmpty()) {
            this.m_7856_();
        }
    }

    @Override
    public void m_6305_(PoseStack mStack, int x, int y, float par3) {
        try {
            if (this.forceMinimapUpdate) {
                if (this.minimap1PreviewButton.m_142518_()) {
                    UIManager.INSTANCE.switchMiniMapPreset(1);
                } else if (this.minimap2PreviewButton.m_142518_()) {
                    UIManager.INSTANCE.switchMiniMapPreset(2);
                }
            }
            if (this.f_96541_.f_91073_ != null) {
                this.updateRenderStats();
            }
            List<FormattedCharSequence> lastTooltip = this.optionsListPane.lastTooltip;
            long lastTooltipTime = this.optionsListPane.lastTooltipTime;
            if (!this.minimapDragging) {
                this.optionsListPane.lastTooltip = null;
                this.optionsListPane.m_6305_(mStack, x, y, par3);
            }
            super.m_6305_(mStack, x, y, par3);
            if (this.previewMiniMap()) {
                UIManager.INSTANCE.getMiniMap().drawMap(mStack, true);
            }
            if (this.optionsListPane.lastTooltip != null && !this.minimapDragging && !this.optionsListPane.lastTooltip.equals(lastTooltip)) {
                this.optionsListPane.lastTooltipTime = lastTooltipTime;
                if (System.currentTimeMillis() - this.optionsListPane.lastTooltipTime > this.optionsListPane.hoverDelay) {
                    Button button = this.optionsListPane.lastTooltipMetadata.getButton();
                    this.m_96617_(mStack, this.optionsListPane.lastTooltip, x, button.getBottomY() + 15);
                }
            }
        }
        catch (Throwable t) {
            JMLogger.logOnce("Error in OptionsManager.render(): " + t, t);
        }
    }

    private void updateRenderStats() {
        RenderSpec.getSurfaceSpec();
        RenderSpec.getTopoSpec();
        RenderSpec.getUndergroundSpec();
        for (Slot slot : this.optionsListPane.getRootSlots()) {
            CategorySlot categorySlot;
            if (!(slot instanceof CategorySlot) || (categorySlot = (CategorySlot)slot).getCategory() != ClientCategory.Cartography) continue;
            CoreProperties coreProperties = JourneymapClient.getInstance().getCoreProperties();
            for (SlotMetadata slotMetadata : categorySlot.getAllChildMetadata()) {
                if (!(slotMetadata.getButton() instanceof IConfigFieldHolder)) continue;
                Object property = ((IConfigFieldHolder)((Object)slotMetadata.getButton())).getConfigField();
                boolean limitButtonRange = false;
                if (property == coreProperties.renderDistanceCaveMax) {
                    limitButtonRange = true;
                    slotMetadata.getButton().resetLabelColors();
                } else if (property == coreProperties.renderDistanceSurfaceMax) {
                    limitButtonRange = true;
                    slotMetadata.getButton().resetLabelColors();
                }
                if (!limitButtonRange) continue;
                IntSliderButton button = (IntSliderButton)slotMetadata.getButton();
                button.maxValue = this.f_96541_.f_91066_.f_92106_;
                if (button.getValue() <= this.f_96541_.f_91066_.f_92106_) continue;
                button.setValue(this.f_96541_.f_91066_.f_92106_);
            }
        }
        String messageString = JourneymapClient.getInstance().getCoreProperties().mappingEnabled.get() != false ? MapPlayerTask.getSimpleStats() : Constants.getString("jm.common.enable_mapping_false_text");
        this.renderStatsButton.m_93666_((Component)Constants.getStringTextComponent(messageString));
        if (this.cartographyCategorySlot != null) {
            this.renderStatsButton.m_93674_(this.cartographyCategorySlot.getCurrentColumnWidth());
        }
    }

    public void m_96558_(PoseStack mStack, int layer) {
    }

    public boolean m_6375_(double mouseX, double mouseY, int mouseButton) {
        if (this.previewMiniMap() && (UIManager.INSTANCE.getMiniMap().withinBounds(mouseX, mouseY) || this.minimapDragging)) {
            return false;
        }
        try {
            boolean pressed = this.optionsListPane.m_6375_(mouseX, mouseY, mouseButton);
            if (pressed) {
                this.checkPressedButton();
            }
            return super.m_6375_(mouseX, mouseY, mouseButton);
        }
        catch (Throwable t) {
            Journeymap.getLogger().error(t.getMessage(), t);
            return false;
        }
    }

    @Override
    public boolean m_6348_(double mouseX, double mouseY, int mouseButton) {
        if (this.minimapDragging) {
            UIManager.INSTANCE.getMiniMap().setDragging(false);
            UIManager.INSTANCE.getMiniMap().updateDisplayVars(true);
        }
        this.minimapDragging = false;
        this.optionsListPane.m_6348_(mouseX, mouseY, mouseButton);
        return super.m_6348_(mouseX, mouseY, mouseButton);
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double mouseDX, double mouseDY) {
        if (this.f_96541_ != null && this.previewMiniMap() && OptionsManager.m_96637_() && this.currentMiniMap.withinBounds(mouseX, mouseY) && Position.Custom.equals(this.currentMiniMapProp.position.get()) || this.minimapDragging) {
            this.currentMiniMap.setDragging(true);
            this.minimapDragging = true;
            int screenHeight = this.f_96541_.m_91268_().m_85444_();
            int screenWidth = this.f_96541_.m_91268_().m_85443_();
            double posX = mouseX * 2.0 + (double)this.currentMiniMap.getDisplayVars().marginX;
            double posY = mouseY * 2.0 + (double)this.currentMiniMap.getDisplayVars().marginY;
            this.currentMiniMapProp.positionX.set((int)(posX / (double)screenWidth * 1000.0));
            this.currentMiniMapProp.positionY.set((int)(posY / (double)screenHeight * 1000.0));
            this.currentMiniMap.updateDisplayVars(true, false);
            return true;
        }
        this.checkPressedButton();
        this.optionsListPane.m_7979_(mouseX, mouseY, button, mouseDX, mouseDY);
        return super.m_7979_(mouseX, mouseY, button, mouseDX, mouseDY);
    }

    public boolean m_6050_(double x, double y, double scroll) {
        this.optionsListPane.m_6050_(x, y, scroll);
        return super.m_6050_(x, y, scroll);
    }

    protected void checkPressedButton() {
        CategorySlot categorySlot;
        SlotMetadata slotMetadata = this.optionsListPane.getLastPressed();
        if (slotMetadata != null) {
            if (slotMetadata.getButton() instanceof ResetButton) {
                this.resetOptions(((ResetButton)slotMetadata.getButton()).category);
            }
            if (slotMetadata.getName().equals(Constants.getString("jm.common.ui_theme"))) {
                ThemeLoader.getCurrentTheme(true);
                if (this.previewMiniMap()) {
                    UIManager.INSTANCE.getMiniMap().updateDisplayVars(true);
                }
            }
            if (this.editGridButtons.contains(slotMetadata.getButton())) {
                UIManager.INSTANCE.openGridEditor(this);
                return;
            }
            if (slotMetadata.getButton() == this.minimap1PreviewButton) {
                this.minimap2PreviewButton.setToggled(false);
                UIManager.INSTANCE.switchMiniMapPreset(1);
                UIManager.INSTANCE.getMiniMap().resetInitTime();
                this.currentMiniMap = UIManager.INSTANCE.getMiniMap();
                this.currentMiniMapProp = this.currentMiniMap.getCurrentMinimapProperties();
            }
            if (slotMetadata.getButton() == this.minimap2PreviewButton) {
                this.minimap1PreviewButton.setToggled(false);
                UIManager.INSTANCE.switchMiniMapPreset(2);
                UIManager.INSTANCE.getMiniMap().resetInitTime();
                this.currentMiniMap = UIManager.INSTANCE.getMiniMap();
                this.currentMiniMapProp = this.currentMiniMap.getCurrentMinimapProperties();
            }
        }
        if ((categorySlot = (CategorySlot)this.optionsListPane.getLastPressedParentSlot()) != null) {
            Category category = categorySlot.getCategory();
            this.changedCategories.add(category);
            if (category == ClientCategory.MiniMap1 || category == ClientCategory.MiniMap2) {
                this.refreshMinimapOptions();
                DataCache.INSTANCE.resetRadarCaches();
                UIManager.INSTANCE.getMiniMap().updateDisplayVars(true);
            }
            if (category == ClientCategory.Cartography) {
                JourneymapClient.getInstance().getCoreProperties().save();
                RenderSpec.resetRenderSpecs();
            }
        }
    }

    protected void actionPerformed(Button button) {
        if (button == this.minimap1PreviewButton) {
            this.minimap2PreviewButton.setToggled(false);
            UIManager.INSTANCE.switchMiniMapPreset(1);
        }
        if (button == this.minimap2PreviewButton) {
            this.minimap1PreviewButton.setToggled(false);
            UIManager.INSTANCE.switchMiniMapPreset(2);
        }
    }

    @Override
    public boolean m_5534_(char typedChar, int keyCode) {
        switch (keyCode) {
            case 256: {
                if (this.previewMiniMap()) {
                    this.minimap1PreviewButton.setToggled(false);
                    this.minimap2PreviewButton.setToggled(false);
                    break;
                }
                this.closeAndReturn();
            }
        }
        boolean optionUpdated = this.optionsListPane.m_5534_(typedChar, keyCode);
        if (optionUpdated && this.previewMiniMap()) {
            UIManager.INSTANCE.getMiniMap().updateDisplayVars(true);
        }
        return true;
    }

    @Override
    public boolean m_7933_(int key, int value, int modifier) {
        switch (key) {
            case 256: {
                if (this.previewMiniMap()) {
                    this.minimap1PreviewButton.setToggled(false);
                    this.minimap2PreviewButton.setToggled(false);
                    break;
                }
                this.closeAndReturn();
            }
        }
        boolean optionUpdated = this.optionsListPane.m_7933_(key, value, modifier);
        if (optionUpdated && this.previewMiniMap()) {
            UIManager.INSTANCE.getMiniMap().updateDisplayVars(true);
        }
        return optionUpdated;
    }

    public void m_96624_() {
        if (InputConstants.m_84830_((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)265)) {
            this.moveMiniMapOnKey(0, -10);
        } else if (InputConstants.m_84830_((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)264)) {
            this.moveMiniMapOnKey(0, 10);
        } else if (InputConstants.m_84830_((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)263)) {
            this.moveMiniMapOnKey(-10, 0);
        } else if (InputConstants.m_84830_((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)262)) {
            this.moveMiniMapOnKey(10, 0);
        }
    }

    private void moveMiniMapOnKey(int incX, int incY) {
        if (this.previewMiniMap() && OptionsManager.m_96637_()) {
            MiniMapProperties prop = UIManager.INSTANCE.getMiniMap().getCurrentMinimapProperties();
            prop.positionX.set(prop.positionX.get() + incX);
            prop.positionY.set(prop.positionY.get() + incY);
            UIManager.INSTANCE.getMiniMap().updateDisplayVars(true);
        }
    }

    protected void resetOptions(Category category) {
        HashSet<PropertiesBase> updatedProperties = new HashSet<PropertiesBase>();
        for (CategorySlot categorySlot : this.optionsListPane.getRootSlots()) {
            if (!category.equals(categorySlot.getCategory())) continue;
            for (SlotMetadata slotMetadata : categorySlot.getAllChildMetadata()) {
                PropertiesBase properties;
                slotMetadata.resetToDefaultValue();
                if (ClientCategory.MiniMap1.equals(category) || ClientCategory.MiniMap2.equals(category)) {
                    UIManager.INSTANCE.getMiniMap().resetState();
                }
                if (ClientCategory.FullMap.equals(category)) {
                    Fullscreen.state().setMapType(MapType.Name.day);
                }
                if (!slotMetadata.hasConfigField() || (properties = slotMetadata.getProperties()) == null) continue;
                updatedProperties.add(properties);
            }
        }
        for (PropertiesBase properties : updatedProperties) {
            properties.save();
        }
        RenderSpec.resetRenderSpecs();
    }

    public boolean previewMiniMap() {
        return this.minimap1PreviewButton.getToggled() != false || this.minimap2PreviewButton.getToggled() != false;
    }

    public void refreshMinimapOptions() {
        HashSet<Category> cats = new HashSet<Category>();
        cats.add(ClientCategory.MiniMap1);
        cats.add(ClientCategory.MiniMap2);
        for (CategorySlot categorySlot : this.optionsListPane.getRootSlots()) {
            if (!cats.contains(categorySlot.getCategory())) continue;
            for (SlotMetadata slotMetadata : categorySlot.getAllChildMetadata()) {
                slotMetadata.getButton().refresh();
            }
        }
    }

    @Override
    protected void closeAndReturn() {
        JourneymapClient.getInstance().getCoreProperties().optionsManagerViewed.set(Journeymap.JM_VERSION.toString());
        JourneymapClient.getInstance().saveConfigProperties();
        if (this.f_96541_.f_91073_ != null) {
            UIManager.INSTANCE.getMiniMap().setMiniMapProperties(JourneymapClient.getInstance().getMiniMapProperties(this.inGameMinimapId));
            for (Category category : this.changedCategories) {
                if (category == ClientCategory.MiniMap1) {
                    DataCache.INSTANCE.resetRadarCaches();
                    UIManager.INSTANCE.getMiniMap().reset();
                    continue;
                }
                if (category == ClientCategory.MiniMap2) {
                    DataCache.INSTANCE.resetRadarCaches();
                    continue;
                }
                if (category == ClientCategory.FullMap) {
                    DataCache.INSTANCE.resetRadarCaches();
                    ThemeLoader.getCurrentTheme(true);
                    continue;
                }
                if (category == ClientCategory.WebMap) {
                    DataCache.INSTANCE.resetRadarCaches();
                    if (JourneymapClient.getInstance().getWebMapProperties().enabled.get().booleanValue()) {
                        Webmap.INSTANCE.start();
                    } else {
                        Webmap.INSTANCE.stop();
                    }
                    ChatLog.announceMod(true);
                    continue;
                }
                if (category == ClientCategory.Waypoint) {
                    WaypointStore.INSTANCE.reset();
                    continue;
                }
                if (category == ClientCategory.WaypointBeacon) continue;
                if (category == ClientCategory.Cartography) {
                    ColorManager.INSTANCE.reset();
                    ModBlockDelegate.INSTANCE.reset();
                    BlockMD.reset();
                    RenderSpec.resetRenderSpecs();
                    TileDrawStepCache.instance().invalidateAll();
                    MiniMap.state().requireRefresh();
                    Fullscreen.state().requireRefresh();
                    MapPlayerTask.forceNearbyRemap();
                    continue;
                }
                if (category != ClientCategory.Advanced) continue;
                SoftResetTask.queue();
                if (JourneymapClient.getInstance().getWebMapProperties().enabled.get().booleanValue()) {
                    Webmap.INSTANCE.start();
                } else {
                    Webmap.INSTANCE.stop();
                }
                ChatLog.announceMod(false);
            }
            UIManager.INSTANCE.getMiniMap().reset();
            UIManager.INSTANCE.getMiniMap().updateDisplayVars(true);
        }
        if (returnDisplayStack != null && !returnDisplayStack.isEmpty() && returnDisplayStack.peek() instanceof Fullscreen) {
            ((Fullscreen)((Object)returnDisplayStack.peek())).reset();
        }
        openCategories.clear();
        for (CategorySlot categorySlot : this.optionsListPane.getRootSlots()) {
            if (!categorySlot.isSelected()) continue;
            openCategories.add(categorySlot.getCategory());
        }
        super.closeAndReturn();
    }

    protected Map<Category, List<SlotMetadata>> getToolbars() {
        if (this.toolbars == null) {
            this.toolbars = new HashMap<Category, List<SlotMetadata>>();
            for (Category category : ClientCategory.values) {
                String name = Constants.getString("jm.config.reset");
                String tooltip = Constants.getString("jm.config.reset.tooltip");
                SlotMetadata toolbarSlotMetadata = new SlotMetadata(new ResetButton(category), name, tooltip);
                this.toolbars.put(category, Arrays.asList(toolbarSlotMetadata));
            }
        }
        return this.toolbars;
    }

    public static class LabelButton
    extends Button {
        DrawUtil.HAlign hAlign = DrawUtil.HAlign.Left;

        public LabelButton(int width, String key, Object ... labelArgs) {
            super(Constants.getString(key, labelArgs));
            this.setTooltip(Constants.getString(key + ".tooltip"));
            this.setDrawBackground(false);
            this.setDrawFrame(false);
            this.setEnabled(false);
            this.setLabelColors(0xC0C0C0, 0xC0C0C0, 0xC0C0C0);
            this.m_93674_(width);
        }

        @Override
        public int getFitWidth(Font fr) {
            return this.f_93618_;
        }

        @Override
        public void fitWidth(Font fr) {
        }

        public void setHAlign(DrawUtil.HAlign hAlign) {
            this.hAlign = hAlign;
        }

        @Override
        public void m_6305_(PoseStack mStack, int mouseX, int mouseY, float ticks) {
            DrawUtil.drawLabel(mStack, this.m_6035_().getString(), switch (this.hAlign) {
                case DrawUtil.HAlign.Left -> this.getRightX();
                case DrawUtil.HAlign.Right -> this.getX();
                default -> this.getCenterX();
            }, this.getMiddleY(), this.hAlign, DrawUtil.VAlign.Middle, null, 0.0f, this.labelColor, 1.0f, 1.0, this.drawLabelShadow);
        }
    }
}

