/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.ui.dialog;

import com.google.common.collect.Maps;
import com.mojang.blaze3d.vertex.PoseStack;
import info.journeymap.shaded.org.jetbrains.annotations.NotNull;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import journeymap.client.Constants;
import journeymap.client.JourneymapClient;
import journeymap.client.data.WorldData;
import journeymap.client.log.JMLogger;
import journeymap.client.ui.component.Button;
import journeymap.client.ui.component.ButtonList;
import journeymap.client.ui.component.JmUI;
import journeymap.client.ui.component.ResetButton;
import journeymap.client.ui.component.ScrollListPane;
import journeymap.client.ui.option.CategorySlot;
import journeymap.client.ui.option.OptionSlotFactory;
import journeymap.client.ui.option.SlotMetadata;
import journeymap.common.Journeymap;
import journeymap.common.network.data.ServerPropertyType;
import journeymap.common.properties.DefaultDimensionProperties;
import journeymap.common.properties.DimensionProperties;
import journeymap.common.properties.GlobalProperties;
import journeymap.common.properties.PropertiesBase;
import journeymap.common.properties.ServerCategory;
import journeymap.common.properties.catagory.Category;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.util.FormattedCharSequence;

public class ServerOptionsManager
extends JmUI {
    protected ScrollListPane<CategorySlot> optionsListPane;
    private final Map<Category, PropertiesBase> slotMap = Maps.newHashMap();
    private GlobalProperties globalProperties;
    private DefaultDimensionProperties defaultDimensionProperties;
    private final Map<String, DimensionProperties> dimensionPropertyMap = Maps.newHashMap();
    protected Map<Category, List<SlotMetadata>> toolbars;
    private final List<Category> categoryList = new ArrayList<Category>(ServerCategory.values);
    private boolean initialized = false;

    public ServerOptionsManager(JmUI returnDisplay) {
        super(JourneymapClient.getInstance().getStateHandler().canServerAdmin() ? Constants.getString("jm.server.edit.label.admin.edit") : Constants.getString("jm.server.edit.label.admin.read_only"), returnDisplay);
        this.requestInitData();
    }

    @Override
    public void m_6305_(PoseStack mStack, int x, int y, float par3) {
        try {
            if (this.optionsListPane != null) {
                List<FormattedCharSequence> lastTooltip = this.optionsListPane.lastTooltip;
                long lastTooltipTime = this.optionsListPane.lastTooltipTime;
                this.optionsListPane.lastTooltip = null;
                this.optionsListPane.m_6305_(mStack, x, y, par3);
                super.m_6305_(mStack, x, y, par3);
                if (this.optionsListPane.lastTooltip != null && !this.optionsListPane.lastTooltip.equals(lastTooltip)) {
                    this.optionsListPane.lastTooltipTime = lastTooltipTime;
                    if (System.currentTimeMillis() - this.optionsListPane.lastTooltipTime > this.optionsListPane.hoverDelay) {
                        Button button = this.optionsListPane.lastTooltipMetadata.getButton();
                        this.m_96617_(mStack, this.optionsListPane.lastTooltip, x, button.getBottomY() + 15);
                    }
                }
            }
        }
        catch (Throwable t) {
            JMLogger.logOnce("Error in OptionsManager.render(): " + t, t);
        }
    }

    public void m_96558_(@NotNull PoseStack mStack, int layer) {
    }

    @Override
    protected void layoutButtons(PoseStack mStack) {
        if (this.f_169369_.isEmpty()) {
            this.m_7856_();
        }
    }

    @Override
    public void m_7856_() {
        if (!this.initialized) {
            this.initialized = true;
            this.f_169369_.clear();
            Button buttonSave = new Button(Constants.getString("jm.waypoint.save"), b -> {
                this.save();
                this.closeAndReturn();
            });
            Button buttonClose = new Button(Constants.getString("jm.server.edit.button.close"), b -> this.closeAndReturn());
            boolean canServerAdmin = JourneymapClient.getInstance().getStateHandler().canServerAdmin();
            buttonSave.setEnabled(canServerAdmin);
            if (!canServerAdmin) {
                buttonSave.setTooltip(Constants.getString("jm.server.button.save.read_only"));
            }
            this.m_142416_((GuiEventListener)buttonClose);
            this.m_142416_((GuiEventListener)buttonSave);
            ButtonList bottomRow = new ButtonList(buttonClose, buttonSave);
            bottomRow.equalizeWidths(this.getFontRenderer());
            bottomRow.setWidths(Math.max(150, buttonClose.m_5711_()));
            bottomRow.layoutCenteredHorizontal(this.f_96543_ / 2, this.f_96544_ - 25, true, 4);
            this.f_169369_.addAll(bottomRow);
        }
        if (this.optionsListPane == null || this.slotMap.size() <= WorldData.getDimensionProviders().size() + 2) {
            Objects.requireNonNull(this);
            this.optionsListPane = new ScrollListPane(this, this.f_96541_, this.f_96543_, this.f_96544_, 35, this.f_96544_ - 30, 20);
            this.optionsListPane.setAlignTop(true);
            List<CategorySlot> categorySlotList = OptionSlotFactory.getOptionSlots(this.getToolbars(), this.slotMap, !JourneymapClient.getInstance().getStateHandler().canServerAdmin());
            this.optionsListPane.setSlots(categorySlotList);
        } else {
            this.optionsListPane.m_93437_(this.f_96543_, this.f_96544_, 35, this.f_96544_ - 30);
        }
        this.optionsListPane.updateSlots();
    }

    protected Map<Category, List<SlotMetadata>> getToolbars() {
        this.toolbars = new HashMap<Category, List<SlotMetadata>>();
        for (Category category : this.categoryList) {
            String name = Constants.getString("jm.config.reset");
            String tooltip = Constants.getString("jm.config.reset.tooltip");
            SlotMetadata toolbarSlotMetadata = new SlotMetadata(new ResetButton(category), name, tooltip);
            this.toolbars.put(category, Collections.singletonList(toolbarSlotMetadata));
        }
        return this.toolbars;
    }

    private void onReset(Category category) {
        for (CategorySlot categorySlot : this.optionsListPane.getRootSlots()) {
            if (!category.equals(categorySlot.getCategory())) continue;
            for (SlotMetadata slotMetadata : categorySlot.getAllChildMetadata()) {
                slotMetadata.resetToDefaultValue();
            }
        }
    }

    private void requestInitData() {
        this.requestData(ServerPropertyType.GLOBAL.getId(), "");
        this.requestData(ServerPropertyType.DEFAULT.getId(), "");
        WorldData.getDimensionProviders().forEach(dimensionProvider -> this.requestData(ServerPropertyType.DIMENSION.getId(), dimensionProvider.getDimensionId()));
    }

    private void requestData(int id, String dim) {
        JourneymapClient.getInstance().getDispatcher().sendServerAdminScreenRequest(id, dim);
    }

    public void setData(ServerPropertyType requestType, String payload, String dim) {
        try {
            if (ServerPropertyType.GLOBAL.equals((Object)requestType)) {
                this.globalProperties = (GlobalProperties)new GlobalProperties().loadForClient(payload, false);
                this.slotMap.put(ServerCategory.Global, this.globalProperties);
            }
            if (ServerPropertyType.DEFAULT.equals((Object)requestType)) {
                this.defaultDimensionProperties = (DefaultDimensionProperties)new DefaultDimensionProperties().loadForClient(payload, false);
                this.slotMap.put(ServerCategory.Default, this.defaultDimensionProperties);
            }
            if (ServerPropertyType.DIMENSION.equals((Object)requestType)) {
                DimensionProperties dimensionProperties = (DimensionProperties)new DimensionProperties(dim.split(":")[1]).loadForClient(payload, false);
                this.dimensionPropertyMap.put(dimensionProperties.getDimension(), dimensionProperties);
                Category category = ServerCategory.create(dim, Constants.getString("jm.server.edit.label.selection.dimension", dim), Constants.getString("jm.server.edit.label.selection.dimension.tooltip"));
                this.categoryList.add(category);
                this.slotMap.put(category, dimensionProperties);
            }
            this.m_7856_();
        }
        catch (Exception e) {
            Journeymap.getLogger().error("Error getting data", (Throwable)e);
        }
    }

    private void save() {
        this.sendSavePacket(ServerPropertyType.GLOBAL.getId(), this.globalProperties.toJsonString(false), "");
        this.sendSavePacket(ServerPropertyType.DEFAULT.getId(), this.defaultDimensionProperties.toJsonString(false), "");
        this.dimensionPropertyMap.values().forEach(dim -> this.sendSavePacket(ServerPropertyType.DIMENSION.getId(), dim.toJsonString(false), dim.getDimension()));
    }

    private void sendSavePacket(int id, String payload, String dim) {
        JourneymapClient.getInstance().getDispatcher().sendSaveAdminDataPacket(id, payload, dim);
    }

    public boolean m_6375_(double mouseX, double mouseY, int mouseButton) {
        try {
            SlotMetadata slotMetadata;
            boolean pressed = this.optionsListPane.m_6375_(mouseX, mouseY, mouseButton);
            if (pressed && (slotMetadata = this.optionsListPane.getLastPressed()) != null && slotMetadata.getButton() instanceof ResetButton) {
                this.onReset(((ResetButton)slotMetadata.getButton()).category);
            }
            return super.m_6375_(mouseX, mouseY, mouseButton);
        }
        catch (Throwable t) {
            Journeymap.getLogger().error(t.getMessage(), t);
            return false;
        }
    }

    public void m_6574_(@NotNull Minecraft minecraft, int width, int height) {
        this.initialized = false;
        super.m_6574_(minecraft, width, height);
    }

    @Override
    public boolean m_6348_(double mouseX, double mouseY, int mouseButton) {
        this.optionsListPane.m_6348_(mouseX, mouseY, mouseButton);
        return super.m_6348_(mouseX, mouseY, mouseButton);
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double mouseDX, double mouseDY) {
        this.optionsListPane.m_7979_(mouseX, mouseY, button, mouseDX, mouseDY);
        return super.m_7979_(mouseX, mouseY, button, mouseDX, mouseDY);
    }

    public boolean m_6050_(double x, double y, double scroll) {
        this.optionsListPane.m_6050_(x, y, scroll);
        return super.m_6050_(x, y, scroll);
    }
}

