/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.ui.fullscreen.layer;

import com.mojang.blaze3d.vertex.PoseStack;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import journeymap.client.Constants;
import journeymap.client.JourneymapClient;
import journeymap.client.data.DataCache;
import journeymap.client.io.ThemeLoader;
import journeymap.client.model.BlockMD;
import journeymap.client.model.ChunkMD;
import journeymap.client.model.MapType;
import journeymap.client.model.RegionCoord;
import journeymap.client.properties.FullMapProperties;
import journeymap.client.render.draw.DrawStep;
import journeymap.client.render.draw.DrawUtil;
import journeymap.client.render.map.GridRenderer;
import journeymap.client.ui.fullscreen.Fullscreen;
import journeymap.client.ui.fullscreen.layer.LayerDelegate;
import journeymap.client.ui.option.LocationFormat;
import journeymap.client.ui.theme.Theme;
import journeymap.client.world.JmBlockAccess;
import journeymap.common.helper.BiomeHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biome;

public class BlockInfoLayer
implements LayerDelegate.Layer {
    public static ResourceLocation serverBiomeName;
    private final List<DrawStep> drawStepList = new ArrayList<DrawStep>(1);
    LocationFormat locationFormat = new LocationFormat();
    LocationFormat.LocationFormatKeys locationFormatKeys;
    BlockPos lastCoord = null;
    PlayerInfoStep playerInfoStep;
    BlockInfoStep blockInfoStep;
    private boolean isSinglePlayer;
    private final Fullscreen fullscreen;
    private final Minecraft mc;

    public BlockInfoLayer(Fullscreen fullscreen) {
        this.fullscreen = fullscreen;
        this.blockInfoStep = new BlockInfoStep();
        this.playerInfoStep = new PlayerInfoStep();
        this.mc = Minecraft.m_91087_();
        this.isSinglePlayer = this.mc.m_91091_();
    }

    @Override
    public List<DrawStep> onMouseMove(Minecraft mc, GridRenderer gridRenderer, Point2D.Double mousePosition, BlockPos blockPos, float fontScale, boolean isScrolling) {
        boolean server = true;
        Rectangle2D.Double optionsToolbarRect = this.fullscreen.getOptionsToolbarBounds();
        Rectangle2D.Double menuToolbarRect = this.fullscreen.getMenuToolbarBounds();
        if (optionsToolbarRect == null || menuToolbarRect == null) {
            return Collections.EMPTY_LIST;
        }
        if (this.drawStepList.isEmpty()) {
            this.drawStepList.add(this.playerInfoStep);
            this.drawStepList.add(this.blockInfoStep);
        }
        this.playerInfoStep.update(mc.m_91268_().m_85443_() / 2, optionsToolbarRect.getMaxY());
        if (!blockPos.equals((Object)this.lastCoord)) {
            this.lastCoord = blockPos;
            ChunkMD chunkMD = DataCache.INSTANCE.getChunkMD(blockPos);
            Object info = "";
            if (chunkMD != null && chunkMD.hasChunk()) {
                server = false;
                BlockMD blockMD = chunkMD.getBlockMD(blockPos.m_7494_());
                if (blockMD == null || blockMD.isIgnore()) {
                    blockMD = chunkMD.getBlockMD(blockPos.m_7495_());
                }
                Biome biome = JmBlockAccess.INSTANCE.getBiome(blockPos);
                RegionCoord regionCoord = RegionCoord.fromChunkPos(null, MapType.none(), chunkMD.getChunk().m_7697_().f_45578_, chunkMD.getChunk().m_7697_().f_45579_);
                String biomeName = BiomeHelper.getTranslatedBiomeName(biome);
                info = this.getBlockInfo(blockPos, biomeName, regionCoord);
                if (!blockMD.isIgnore()) {
                    info = String.format("%s \u25a0 %s", blockMD.getName(), info);
                }
            } else {
                Biome biome;
                info = Constants.getString("jm.common.location_xz_verbose", blockPos.m_123341_(), blockPos.m_123343_());
                if (this.isSinglePlayer && (biome = JmBlockAccess.INSTANCE.getBiome(blockPos)) != null) {
                    info = (String)info + " " + BiomeHelper.getTranslatedBiomeName(biome);
                }
            }
            if (server && JourneymapClient.getInstance().getStateHandler().isJourneyMapServerConnection() && JourneymapClient.getInstance().getStateHandler().useServerFullscreenBiomes()) {
                JourneymapClient.getInstance().getDispatcher().sendBiomeRequest(blockPos);
                if (serverBiomeName != null) {
                    RegionCoord regionCoord = RegionCoord.fromChunkPos(null, MapType.none(), blockPos.m_123341_() >> 4, blockPos.m_123343_() >> 4);
                    String biomeName = BiomeHelper.getTranslatedBiomeName(serverBiomeName);
                    info = this.getBlockInfo(blockPos, biomeName, regionCoord);
                }
            }
            this.blockInfoStep.update((String)info, gridRenderer.getWidth() / 2, menuToolbarRect.getMinY());
        }
        return this.drawStepList;
    }

    private String getBlockInfo(BlockPos blockPos, String biomeName, RegionCoord regionCoord) {
        FullMapProperties fullMapProperties = JourneymapClient.getInstance().getFullMapProperties();
        String region = "Region: x:" + regionCoord.regionX + " z:" + regionCoord.regionZ;
        this.locationFormatKeys = this.locationFormat.getFormatKeys(fullMapProperties.locationFormat.get());
        return this.locationFormatKeys.format(fullMapProperties.locationFormatVerbose.get(), blockPos.m_123341_(), blockPos.m_123343_(), blockPos.m_123342_(), blockPos.m_123342_() >> 4) + " " + biomeName + " " + region;
    }

    @Override
    public List<DrawStep> onMouseClick(Minecraft mc, GridRenderer gridRenderer, Point2D.Double mousePosition, BlockPos blockCoord, int button, boolean doubleClick, float fontScale) {
        return Collections.EMPTY_LIST;
    }

    @Override
    public boolean propagateClick() {
        return true;
    }

    class BlockInfoStep
    implements DrawStep {
        private Theme.LabelSpec labelSpec;
        private double x;
        private double y;
        private String text;

        BlockInfoStep() {
        }

        void update(String text, double x, double y) {
            Theme theme = ThemeLoader.getCurrentTheme();
            this.labelSpec = theme.fullscreen.statusLabel;
            this.text = text;
            this.x = x;
            this.y = y - (double)theme.container.toolbar.horizontal.margin * BlockInfoLayer.this.fullscreen.getScreenScaleFactor();
        }

        @Override
        public void draw(PoseStack mStack, MultiBufferSource buffers, DrawStep.Pass pass, double xOffset, double yOffset, GridRenderer gridRenderer, double fontScale, double rotation) {
            if (pass == DrawStep.Pass.Text && JourneymapClient.getInstance().getFullMapProperties().showMouseLoc.get().booleanValue()) {
                DrawUtil.drawLabel(mStack, this.text, this.labelSpec, this.x, this.y, DrawUtil.HAlign.Center, DrawUtil.VAlign.Above, fontScale, 0.0);
            }
        }

        @Override
        public int getDisplayOrder() {
            return 0;
        }

        @Override
        public String getModId() {
            return "journeymap";
        }
    }

    class PlayerInfoStep
    implements DrawStep {
        private Theme.LabelSpec labelSpec;
        private String prefix;
        private double x;
        private double y;

        PlayerInfoStep() {
        }

        void update(double x, double y) {
            Theme theme = ThemeLoader.getCurrentTheme();
            this.labelSpec = theme.fullscreen.statusLabel;
            if (this.prefix == null) {
                this.prefix = BlockInfoLayer.this.mc.f_91074_.m_7755_().getString() + " \u25a0 ";
            }
            this.x = x;
            this.y = y + (double)theme.container.toolbar.horizontal.margin * BlockInfoLayer.this.fullscreen.getScreenScaleFactor();
        }

        @Override
        public void draw(PoseStack mStack, MultiBufferSource buffers, DrawStep.Pass pass, double xOffset, double yOffset, GridRenderer gridRenderer, double fontScale, double rotation) {
            if (pass == DrawStep.Pass.Text && JourneymapClient.getInstance().getFullMapProperties().showPlayerLoc.get().booleanValue()) {
                DrawUtil.drawLabel(mStack, this.prefix + Fullscreen.state().playerLastPos, this.labelSpec, this.x, this.y, DrawUtil.HAlign.Center, DrawUtil.VAlign.Below, fontScale, 0.0);
            }
        }

        @Override
        public int getDisplayOrder() {
            return 0;
        }

        @Override
        public String getModId() {
            return "journeymap";
        }
    }
}

