/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.ui.theme;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import journeymap.client.Constants;
import journeymap.client.render.RenderWrapper;
import journeymap.client.render.draw.DrawUtil;
import journeymap.client.render.texture.TextureCache;
import journeymap.client.render.texture.TextureImpl;
import journeymap.client.ui.component.BooleanPropertyButton;
import journeymap.client.ui.theme.Theme;
import journeymap.common.properties.config.BooleanField;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Style;
import net.minecraft.util.FormattedCharSequence;
import net.minecraftforge.fmlclient.gui.GuiUtils;

public class ThemeButton
extends BooleanPropertyButton {
    protected Theme theme;
    protected Theme.Control.ButtonSpec buttonSpec;
    protected TextureImpl textureOn;
    protected TextureImpl textureHover;
    protected TextureImpl textureOff;
    protected TextureImpl textureDisabled;
    protected TextureImpl textureIcon;
    protected String iconName;
    protected List<FormattedCharSequence> additionalTooltips;
    protected boolean staysOn;
    private boolean displayClickToggle = true;

    public void setDisplayClickToggle(boolean displayClickToggle) {
        this.displayClickToggle = displayClickToggle;
    }

    public ThemeButton(Theme theme, String rawLabel, String iconName, Button.OnPress onPress) {
        this(theme, Constants.getString(rawLabel), Constants.getString(rawLabel), false, iconName, onPress);
    }

    public ThemeButton(Theme theme, String labelOn, String labelOff, boolean toggled, String iconName, Button.OnPress onPress) {
        super(labelOn, labelOff, null, onPress);
        this.iconName = iconName;
        this.setToggled(toggled);
        this.updateTheme(theme);
    }

    protected ThemeButton(Theme theme, String labelOn, String labelOff, String iconName, BooleanField field, Button.OnPress onPress) {
        super(labelOn, labelOff, field, onPress);
        this.iconName = iconName;
        this.updateTheme(theme);
    }

    public boolean isStaysOn() {
        return this.staysOn;
    }

    public void setStaysOn(boolean staysOn) {
        this.staysOn = staysOn;
    }

    public void updateTheme(Theme theme) {
        this.theme = theme;
        this.buttonSpec = this.getButtonSpec(theme);
        if (this.buttonSpec.useThemeImages) {
            String pattern = this.getPathPattern();
            String prefix = this.buttonSpec.prefix;
            this.textureOn = TextureCache.getThemeTexture(theme, String.format(pattern, prefix, "on"));
            this.textureOff = TextureCache.getThemeTexture(theme, String.format(pattern, prefix, "off"));
            this.textureHover = TextureCache.getThemeTexture(theme, String.format(pattern, prefix, "hover"));
            this.textureDisabled = TextureCache.getThemeTexture(theme, String.format(pattern, prefix, "disabled"));
        } else {
            this.textureOn = null;
            this.textureOff = null;
            this.textureHover = null;
            this.textureDisabled = null;
        }
        this.textureIcon = TextureCache.getThemeTexture(theme, String.format("icon/%s.png", this.iconName));
        this.m_93674_(this.buttonSpec.width);
        this.setHeight(this.buttonSpec.height);
        this.setToggled(false, false);
    }

    public boolean hasValidTextures() {
        if (this.buttonSpec.useThemeImages) {
            return RenderWrapper.isTexture(this.textureOn.getGlTextureId(false)) && RenderWrapper.isTexture(this.textureOff.getGlTextureId(false));
        }
        return true;
    }

    protected String getPathPattern() {
        return "control/%sbutton_%s.png";
    }

    protected Theme.Control.ButtonSpec getButtonSpec(Theme theme) {
        return theme.control.button;
    }

    public Theme.Control.ButtonSpec getButtonSpec() {
        return this.buttonSpec;
    }

    protected TextureImpl getActiveTexture(boolean isMouseOver) {
        if (!this.isEnabled()) {
            return this.textureDisabled;
        }
        return this.toggled != false ? this.textureOn : this.textureOff;
    }

    protected Theme.ColorSpec getIconColor(boolean isMouseOver) {
        if (!this.isEnabled()) {
            return this.buttonSpec.iconDisabled;
        }
        if (isMouseOver) {
            return this.toggled != false ? this.buttonSpec.iconHoverOn : this.buttonSpec.iconHoverOff;
        }
        return this.toggled.booleanValue() ? (this.displayClickToggle ? this.buttonSpec.iconOn : this.buttonSpec.iconOff) : this.buttonSpec.iconOff;
    }

    protected Theme.ColorSpec getButtonColor(boolean isMouseOver) {
        if (!this.isEnabled()) {
            return this.buttonSpec.buttonDisabled;
        }
        if (isMouseOver) {
            return this.toggled.booleanValue() ? (this.displayClickToggle ? this.buttonSpec.buttonHoverOn : this.buttonSpec.buttonHoverOff) : this.buttonSpec.buttonHoverOff;
        }
        return this.toggled.booleanValue() ? (this.displayClickToggle ? this.buttonSpec.buttonOn : this.buttonSpec.buttonOff) : this.buttonSpec.buttonOff;
    }

    @Override
    public void m_6305_(PoseStack mStack, int mouseX, int mouseY, float ticks) {
        if (!this.isVisible()) {
            return;
        }
        boolean hover = mouseX >= this.f_93620_ && mouseY >= this.f_93621_ && mouseX < this.f_93620_ + this.f_93618_ && mouseY < this.f_93621_ + this.f_93619_;
        this.setMouseOver(hover);
        TextureImpl activeTexture = this.getActiveTexture(this.f_93622_);
        Theme.ColorSpec iconColorSpec = this.getIconColor(this.f_93622_);
        int drawX = this.getX();
        int drawY = this.getY();
        RenderWrapper.enableDepthTest();
        if (this.buttonSpec.useThemeImages) {
            RenderWrapper.setShader(GameRenderer::m_172817_);
            Theme.ColorSpec buttonColorSpec = this.getButtonColor(this.f_93622_);
            float buttonScale = 1.0f;
            if (this.buttonSpec.width != activeTexture.getWidth()) {
                buttonScale = 1.0f * (float)this.buttonSpec.width / (float)activeTexture.getWidth();
            }
            DrawUtil.drawColoredImage(mStack, activeTexture, buttonColorSpec.getColor(), buttonColorSpec.alpha, drawX, drawY, buttonScale, 0.0);
        } else {
            this.drawNativeButton(mStack, mouseX, mouseY);
        }
        float iconScale = 1.0f;
        if (this.theme.icon.width != this.textureIcon.getWidth()) {
            iconScale = 1.0f * (float)this.theme.icon.width / (float)this.textureIcon.getWidth();
        }
        if (!this.buttonSpec.useThemeImages) {
            DrawUtil.drawColoredImage(mStack, this.textureIcon, 0, iconColorSpec.alpha, (double)drawX + 0.5, (double)drawY + 0.5, iconScale, 0.0);
        }
        DrawUtil.drawColoredImage(mStack, this.textureIcon, iconColorSpec.getColor(), iconColorSpec.alpha, drawX, drawY, iconScale, 0.0);
    }

    public void drawNativeButton(PoseStack mStack, int mouseX, int mouseY) {
        mStack.m_85836_();
        int magic = 20;
        RenderWrapper.setShader(GameRenderer::m_172817_);
        RenderWrapper.setShaderTexture(0, Button.f_93617_);
        RenderWrapper.setColor4f(1.0f, 1.0f, 1.0f, 1.0f);
        int k = this.isEnabled() ? (this.m_5702_() ? 2 : 1) : 0;
        RenderWrapper.enableBlend();
        RenderWrapper.blendFunc(770, 771);
        GuiUtils.drawTexturedModalRect((PoseStack)mStack, (int)this.f_93620_, (int)this.f_93621_, (int)0, (int)(46 + k * magic), (int)(this.f_93618_ / 2), (int)this.f_93619_, (float)this.m_93252_());
        GuiUtils.drawTexturedModalRect((PoseStack)mStack, (int)(this.f_93620_ + this.f_93618_ / 2), (int)this.f_93621_, (int)(200 - this.f_93618_ / 2), (int)(46 + k * magic), (int)(this.f_93618_ / 2), (int)this.f_93619_, (float)this.m_93252_());
        this.m_7979_(mouseX, mouseY, 0, this.f_93620_, this.f_93621_);
        int l = 0xE0E0E0;
        mStack.m_85849_();
    }

    public void setAdditionalTooltips(List<FormattedCharSequence> additionalTooltips) {
        this.additionalTooltips = additionalTooltips;
    }

    @Override
    public List<FormattedCharSequence> getTooltip() {
        if (!this.f_93624_) {
            return null;
        }
        List<FormattedCharSequence> list = super.getTooltip();
        String styleCode = null;
        styleCode = !this.isEnabled() ? this.buttonSpec.tooltipDisabledStyle : (this.toggled != false ? this.buttonSpec.tooltipOnStyle : this.buttonSpec.tooltipOffStyle);
        Style style = styleCode.isEmpty() || "".equals(styleCode) ? Style.f_131099_ : Style.f_131099_.m_131157_(ChatFormatting.m_126645_((char)styleCode.charAt(1)));
        list.add(0, FormattedCharSequence.m_13714_((String)this.m_6035_().getString(), (Style)style));
        if (this.additionalTooltips != null) {
            list.addAll(this.additionalTooltips);
        }
        return list;
    }
}

