/*
 * Decompiled with CFR 0.152.
 */
package journeymap.common.events;

import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.UUID;
import journeymap.common.Journeymap;
import journeymap.common.helper.DimensionHelper;
import journeymap.common.properties.GlobalProperties;
import journeymap.common.properties.PropertiesManager;
import journeymap.common.properties.ServerOption;
import journeymap.common.util.PermissionsManager;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fmllegacy.server.ServerLifecycleHooks;

public class ForgeEvents {
    private static int playerUpdateTicks = 5;

    @SubscribeEvent
    public void onServerTickEvent(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            return;
        }
        if (((ServerOption)PropertiesManager.getInstance().getGlobalProperties().worldPlayerRadar.get()).enabled() && ServerLifecycleHooks.getCurrentServer().m_6846_().m_11314_().size() > 1) {
            playerUpdateTicks = PropertiesManager.getInstance().getGlobalProperties().worldPlayerRadarUpdateTime.get();
            ServerLevel world = ServerLifecycleHooks.getCurrentServer().m_129880_(Level.f_46428_);
            if (world != null && world.m_46468_() % (long)playerUpdateTicks == 0L) {
                this.sendPlayersOnRadarToPlayers();
            }
        }
    }

    @SubscribeEvent
    public void onEntityJoinWorldEvent(EntityJoinWorldEvent event) {
        if (event.getEntity() instanceof ServerPlayer) {
            this.sendConfigsToPlayer((ServerPlayer)event.getEntity());
        }
    }

    @SubscribeEvent
    public void onPlayerLoggedInEvent(PlayerEvent.PlayerLoggedInEvent event) {
        if (event.getPlayer() instanceof ServerPlayer) {
            this.sendConfigsToPlayer((ServerPlayer)event.getPlayer());
        }
    }

    private void sendConfigsToPlayer(ServerPlayer player) {
        PermissionsManager.getInstance().sendPermissions(player);
    }

    private void sendPlayersOnRadarToPlayers() {
        GlobalProperties prop = PropertiesManager.getInstance().getGlobalProperties();
        ServerOption option = (ServerOption)prop.worldPlayerRadar.get();
        for (ServerPlayer player : ServerLifecycleHooks.getCurrentServer().m_6846_().m_11314_()) {
            boolean playerRadarEnabled = PropertiesManager.getInstance().getDimProperties((String)DimensionHelper.getDimName((Entity)player)).playerRadarEnabled.get();
            boolean receiverOp = Journeymap.isOp((Player)player);
            if ((!option.enabled() || !playerRadarEnabled) && (!option.canOps() || !receiverOp)) continue;
            try {
                this.sendPlayerTrackingData(player, receiverOp);
            }
            catch (ConcurrentModificationException concurrentModificationException) {}
        }
    }

    private void sendPlayerTrackingData(ServerPlayer entityPlayerMP, boolean receiverOp) {
        ArrayList serverPlayers = new ArrayList(ServerLifecycleHooks.getCurrentServer().m_6846_().m_11314_());
        if (serverPlayers != null && serverPlayers.size() > 1) {
            for (ServerPlayer radarPlayer : serverPlayers) {
                boolean sameDimension = entityPlayerMP.f_19853_.m_46472_().equals((Object)radarPlayer.f_19853_.m_46472_());
                boolean sneaking = radarPlayer.m_6144_();
                boolean hideOp = PropertiesManager.getInstance().getGlobalProperties().hideOps.get();
                boolean hideSpectators = PropertiesManager.getInstance().getGlobalProperties().hideSpectators.get() != false && radarPlayer.m_5833_();
                boolean visible = sameDimension && (receiverOp || !hideOp && !sneaking && !hideSpectators);
                UUID playerId = radarPlayer.m_142081_();
                if (entityPlayerMP.m_142081_().equals(playerId)) continue;
                Journeymap.getInstance().getDispatcher().sendPlayerLocationPacket(entityPlayerMP, radarPlayer, visible);
            }
        }
    }
}

