/*
 * Decompiled with CFR 0.152.
 */
package journeymap.common.nbt;

import java.util.UUID;
import journeymap.common.Journeymap;
import journeymap.common.nbt.NBTWorldSaveDataHandler;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraftforge.fmllegacy.server.ServerLifecycleHooks;

public class WorldNbtIDSaveHandler {
    private static final String DAT_FILE = "WorldUUID";
    private static final String WORLD_ID_KEY = "world_uuid";
    private NBTWorldSaveDataHandler data;
    private Level world;

    public WorldNbtIDSaveHandler() {
        try {
            this.world = ServerLifecycleHooks.getCurrentServer().m_129880_(Level.f_46428_);
            this.data = (NBTWorldSaveDataHandler)((ServerLevel)this.world).m_8895_().m_164858_(NBTWorldSaveDataHandler::load, DAT_FILE);
        }
        catch (Exception e) {
            Journeymap.getLogger().warn("Error in worldID handler", (Throwable)e);
        }
    }

    public String getWorldID() {
        return this.getNBTWorldID();
    }

    private String getNBTWorldID() {
        if (this.data == null) {
            return this.createNewWorldID();
        }
        if (this.data.getData().m_128441_(WORLD_ID_KEY)) {
            return this.data.getData().m_128461_(WORLD_ID_KEY);
        }
        return "noWorldIDFound";
    }

    private String createNewWorldID() {
        String worldID = UUID.randomUUID().toString();
        this.data = new NBTWorldSaveDataHandler(worldID);
        this.world = ServerLifecycleHooks.getCurrentServer().m_129880_(Level.f_46428_);
        ((ServerLevel)this.world).m_8895_().m_164855_(DAT_FILE, (SavedData)this.data);
        this.saveWorldID(worldID);
        return worldID;
    }

    private void saveWorldID(String worldID) {
        if (this.data != null) {
            this.data.getData().m_128359_(WORLD_ID_KEY, worldID);
            this.data.m_77762_();
        }
    }
}

