/*
 * Decompiled with CFR 0.152.
 */
package journeymap.common.network.forge;

import java.util.function.Supplier;
import journeymap.client.JourneymapClient;
import journeymap.common.Journeymap;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.fmllegacy.network.NetworkEvent;

public class BiomePacket {
    private ResourceLocation biomeResource;
    private BlockPos pos;

    public BiomePacket() {
    }

    public BiomePacket(ResourceLocation biomeResource) {
        this.biomeResource = biomeResource;
        this.pos = BlockPos.f_121853_;
    }

    public BiomePacket(BlockPos pos) {
        this.pos = pos;
        this.biomeResource = new ResourceLocation("");
    }

    public BiomePacket(FriendlyByteBuf buf) {
        try {
            if (buf.capacity() > 1) {
                this.biomeResource = buf.m_130281_();
                this.pos = buf.m_130135_();
            }
        }
        catch (Throwable t) {
            Journeymap.getLogger().error(String.format("Failed to read message for teleport packet: %s", t));
        }
    }

    public void encode(FriendlyByteBuf buf) {
        try {
            buf.m_130085_(this.biomeResource);
            buf.m_130064_(this.pos);
        }
        catch (Throwable t) {
            Journeymap.getLogger().error("[toBytes]Failed to write message for teleport packet:" + t);
        }
    }

    public static void handle(BiomePacket packet, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            if (((NetworkEvent.Context)ctx.get()).getDirection().getReceptionSide().isServer()) {
                Journeymap.getInstance().getPacketHandler().handleBiomeRequest(((NetworkEvent.Context)ctx.get()).getSender(), packet.pos);
            } else {
                JourneymapClient.getInstance().getPacketHandler().handleBiomeResponse(packet.biomeResource);
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

