/*
 * Decompiled with CFR 0.152.
 */
package journeymap.common.network.forge;

import java.util.function.Supplier;
import journeymap.client.JourneymapClient;
import journeymap.common.Journeymap;
import journeymap.common.network.data.model.ClientState;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.fmllegacy.network.NetworkEvent;

public class ClientPermissionsPacket
implements ClientState {
    private String payload;
    private boolean serverAdmin;

    public ClientPermissionsPacket() {
        this.payload = "";
    }

    public ClientPermissionsPacket(String payload, boolean serverAdmin) {
        this.payload = payload;
        this.serverAdmin = serverAdmin;
    }

    @Override
    public String getPayload() {
        return this.payload;
    }

    @Override
    public boolean isServerAdmin() {
        return this.serverAdmin;
    }

    public ClientPermissionsPacket(FriendlyByteBuf buf) {
        try {
            if (buf.capacity() > 1) {
                buf.readByte();
                this.serverAdmin = buf.readBoolean();
                this.payload = buf.m_130136_(Short.MAX_VALUE);
            }
        }
        catch (Throwable t) {
            Journeymap.getLogger().error(String.format("Failed to read message for client permissions: %s", t));
        }
    }

    public void encode(FriendlyByteBuf buf) {
        try {
            if (this.payload != null) {
                buf.writeByte(42);
                buf.writeBoolean(this.serverAdmin);
                buf.m_130070_(this.payload);
            }
        }
        catch (Throwable t) {
            Journeymap.getLogger().error("[toBytes]Failed to write message for client permissions:" + t);
        }
    }

    public static void handle(ClientPermissionsPacket packet, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            if (((NetworkEvent.Context)ctx.get()).getDirection().getReceptionSide().isServer()) {
                Journeymap.getInstance().getPacketHandler().onClientPermsRequest(((NetworkEvent.Context)ctx.get()).getSender());
            } else {
                JourneymapClient.getInstance().getPacketHandler().onClientStateUpdate(packet);
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

