/*
 * Decompiled with CFR 0.152.
 */
package journeymap.common.network.handler;

import java.util.Arrays;
import journeymap.client.JourneymapClient;
import journeymap.client.ui.UIManager;
import journeymap.client.ui.dialog.ServerOptionsManager;
import journeymap.client.ui.fullscreen.Fullscreen;
import journeymap.client.ui.fullscreen.layer.BlockInfoLayer;
import journeymap.client.waypoint.Waypoint;
import journeymap.client.waypoint.WaypointStore;
import journeymap.common.Journeymap;
import journeymap.common.command.CreateWaypoint;
import journeymap.common.network.data.ServerPropertyType;
import journeymap.common.network.data.model.ClientState;
import journeymap.common.network.data.model.PlayerLocation;
import journeymap.common.util.PlayerRadarManager;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;

public class ClientPacketHandler {
    public void onClientStateUpdate(ClientState packet) {
        JourneymapClient.getInstance().getStateHandler().setStates(packet);
    }

    public void onServerAdminDataResponse(int type, String payload, String dimension) {
        ServerOptionsManager serverOptionsManager = UIManager.INSTANCE.getServerEditor();
        if (serverOptionsManager != null) {
            serverOptionsManager.setData(ServerPropertyType.getFromType(type), payload, dimension);
        }
    }

    public void onPlayerLocationPacket(PlayerLocation packet) {
        PlayerRadarManager.getInstance().updatePlayers(packet);
    }

    public void onWaypointCreatePacket(String waypoint, String action, boolean announce) {
        TranslatableComponent message = null;
        if ("create".equalsIgnoreCase(action)) {
            Waypoint clientWaypoint = Waypoint.fromString(waypoint);
            WaypointStore.INSTANCE.save(clientWaypoint);
            Fullscreen.state().requireRefresh();
            message = new TranslatableComponent("jm.common.waypoint.create_packet", new Object[]{clientWaypoint.getPrettyName(), clientWaypoint.getX(), clientWaypoint.getY(), clientWaypoint.getZ(), clientWaypoint.getDimensions()});
        } else if ("delete".equalsIgnoreCase(action)) {
            CreateWaypoint.CommandWaypoint commandWaypoint = CreateWaypoint.CommandWaypoint.fromString(waypoint);
            for (Waypoint wp : WaypointStore.INSTANCE.getAll()) {
                if (!commandWaypoint.name.equalsIgnoreCase(wp.getName()) || !wp.getOrigin().equals(commandWaypoint.origin) || !ClientPacketHandler.validOrigin(commandWaypoint.origin)) continue;
                WaypointStore.INSTANCE.remove(wp);
                message = new TranslatableComponent("jm.common.waypoint.delete_packet", new Object[]{wp.getPrettyName()});
                break;
            }
        }
        if (announce && message != null) {
            Minecraft.m_91087_().f_91065_.m_93076_().m_93785_(message);
        }
        Journeymap.getLogger().info(message.getString());
    }

    private static boolean validOrigin(String origin) {
        return Arrays.asList("server", "command", "external").contains(origin);
    }

    public void onWorldIdReceived(String worldId) {
        JourneymapClient.getInstance().setCurrentWorldId(worldId);
    }

    public void handleBiomeResponse(ResourceLocation biomeResource) {
        BlockInfoLayer.serverBiomeName = biomeResource;
    }
}

