/*
 * Decompiled with CFR 0.152.
 */
package journeymap.common.network.handler;

import journeymap.client.Constants;
import journeymap.common.Journeymap;
import journeymap.common.helper.DimensionHelper;
import journeymap.common.nbt.WorldNbtIDSaveHandler;
import journeymap.common.network.data.ServerPropertyType;
import journeymap.common.network.data.model.Location;
import journeymap.common.properties.DimensionProperties;
import journeymap.common.properties.PropertiesBase;
import journeymap.common.properties.PropertiesManager;
import journeymap.common.util.JourneyMapTeleport;
import journeymap.common.util.PermissionsManager;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.biome.Biome;
import net.minecraftforge.fml.loading.FMLLoader;
import net.minecraftforge.fmllegacy.server.ServerLifecycleHooks;

public class PacketHandler {
    public void handleTeleportPacket(ServerPlayer player, Location location) {
        JourneyMapTeleport.instance().attemptTeleport((Entity)player, location);
    }

    public void onClientPermsRequest(ServerPlayer sender) {
        PermissionsManager.getInstance().sendPermissions(sender);
    }

    public void onAdminScreenOpen(ServerPlayer sender, int type, String dimension) {
        PropertiesManager pm = PropertiesManager.getInstance();
        if (PermissionsManager.getInstance().canServerAdmin(sender) || FMLLoader.getDist().isClient() || pm.getGlobalProperties().viewOnlyServerProperties.get().booleanValue()) {
            Journeymap.getInstance().getDispatcher().sendServerAdminPacket(sender, type, switch (ServerPropertyType.getFromType(type)) {
                case ServerPropertyType.GLOBAL -> pm.getGlobalProperties().toJsonString(false);
                case ServerPropertyType.DEFAULT -> pm.getDefaultDimensionProperties().toJsonString(false);
                default -> pm.getDimProperties(dimension).toJsonString(false);
            }, dimension);
        } else {
            sender.m_6352_((Component)Constants.getStringTextComponent("You do not have permission to modify Journeymap's server options!"), Util.f_137441_);
        }
    }

    public void onServerAdminSave(ServerPlayer sender, Integer type, String payload, String dimension) {
        if (PermissionsManager.getInstance().canServerAdmin(sender) || FMLLoader.getDist().isClient()) {
            switch (ServerPropertyType.getFromType(type)) {
                case GLOBAL: {
                    ((PropertiesBase)PropertiesManager.getInstance().getGlobalProperties().load(payload, false)).save();
                    PacketHandler.updatePlayers("global");
                    break;
                }
                case DEFAULT: {
                    ((PropertiesBase)PropertiesManager.getInstance().getDefaultDimensionProperties().load(payload, false)).save();
                    break;
                }
                default: {
                    DimensionProperties prop = (DimensionProperties)PropertiesManager.getInstance().getDimProperties(dimension).load(payload, true);
                    prop.save();
                    if (!prop.enabled.get().booleanValue()) break;
                    PacketHandler.updatePlayers(dimension);
                }
            }
            PropertiesManager.getInstance().reloadConfigs();
        } else {
            sender.m_6352_((Component)Constants.getStringTextComponent("You do not have permission to modify Journeymap's server options!"), Util.f_137441_);
        }
    }

    private static void updatePlayers(String dim) {
        for (ServerPlayer player : ServerLifecycleHooks.getCurrentServer().m_6846_().m_11314_()) {
            if (!dim.equals(DimensionHelper.getDimName((Entity)player)) && !"global".equals(dim)) continue;
            PermissionsManager.getInstance().sendPermissions(player);
        }
    }

    public void onWorldIdRequest(ServerPlayer sender) {
        if (PropertiesManager.getInstance().getGlobalProperties().useWorldId.get().booleanValue()) {
            WorldNbtIDSaveHandler worldSaveHandler = new WorldNbtIDSaveHandler();
            String worldId = worldSaveHandler.getWorldID();
            Journeymap.getInstance().getDispatcher().sendWorldIdPacket(sender, worldId);
        }
    }

    public void handleBiomeRequest(ServerPlayer sender, BlockPos pos) {
        Biome biome = sender.f_19853_.m_46857_(pos);
        ResourceLocation biomeResource = sender.f_19853_.m_5962_().m_175515_(Registry.f_122885_).m_7981_((Object)biome);
        Journeymap.getInstance().getDispatcher().sendBiomeResource(sender, biomeResource);
    }
}

